
//       



faclib::truncate:=
proc(p,k)
begin
if iszero(p) then return(p); end_if;
if nterms(p)=1 then 
        if degree(p)<k then return(p) else return(p-p);  end_if;
end_if;
_plus(op(select(monomials(p), 
        proc() begin degree(args(1)) < k end_proc )))
end_proc:

faclib::multifactor:=proc(f)
local i,j,l,F,xx,factlist,result;
begin
 if type(f)<>DOM_POLY then error("not a polynomial") end_if;
 xx:=op(f,2);
 if nops(xx)<2 then error("multivariate polynomial expected"); end_if;
 F:=op(f,3);
   if F::hasProp(Cat::Field)<>TRUE then
         error("coefficient ring should be a field")
   end_if;
l:=faclib::pre_factor(f);
result:=[op(l,1)];
for i from 2 to nops(l) step 2 do
	if nops(op(l,[i,2]))=1 then 
		factlist:=factor(op(l,i));
                factlist:=Factored::convert_to(factlist,DOM_LIST);
	else
		factlist:=faclib::mufactor(op(l,i));
	end_if;
	result[1]:=result[1]*factlist[1];
	for j from 3 to nops(factlist) step 2 do
		factlist[j]:=factlist[j]*op(l,i+1);
	end_for;
	if op(l,[i,2])<>xx then
		for j from 2 to nops(factlist) step 2 do
			factlist[j]:=subsop(factlist[j],2=xx);
		end_for;
	end_if;
	result:=result.[op(factlist,2..nops(factlist))];
end_for;
result
end_proc:

faclib::mufactor:=proc(f)
local l,F,factlist,result,i,j,st;

begin
 F:=op(f,3);  
  st:=time();
  l:=Factored::convert_to( polylib::sqrfree(f),DOM_LIST );
  userinfo(2,"Time for squarefree factorization:".expr2text(time()-st));
   result:=[op(l,1)];
   for i from 2 to nops(l) step 2 do
        factlist:=faclib::multihensel(op(l,i));
        result:=result.[(op(factlist,j),op(l,i+1)) $j=1..nops(factlist) ];
    end_for;
    result
end_proc:


/* If f \in F[x1,..,xn] , f primitive,
  and I is the ideal generated by x2,..,xn,
  multihensel computes a factorization of f */
/* by first computing a factorization modulo I^d, where
  d is ''big enough'' */
  /* Note that a polynomial is an element of I^k iff any of its
    coefficients with respect to x1 has total degree >= k w.r.t. x2,..,xn */

faclib::multihensel:=proc(f)
local ff,f0,fi,R,X,y,df,q,a,e,r,s,t,fprod,g,h,i,j,k,l,evpoints,
	iindets,nindets,F,d,lc,st,factorsleft,setleft,factlist;
save SEED;

begin
SEED:= 1; // to ensure reproducible behavior
iindets:=op(f,2);
nindets:=nops(op(f,2));
/* as f is primitive, if it has degree =1 with respect to one variable,
  it must be irreducible */
if has([degree(f,iindets[i]) $i=1..nindets],1) then
	 userinfo(2,"Irreducible by degree argument");
	 return([f]);
end_if;

// exchange variables if f has zero derivative 
// as f is squarefree, this cannot happen for all variables 
i:=0;
repeat
	i:=i+1;
until not iszero(D([i],f)) end_repeat;
X:=op(iindets,1);
if i>1 then
	nindets:=iindets;
	iindets[1]:=iindets[i];
	iindets[i]:=X;
	g:=subsop(f,2=iindets);
	return(map(faclib::multihensel(g),proc() begin subsop(args(1),2=nindets) end_proc ));
end_if;	
userinfo(2,"Using ".expr2text(X)." as main variable");
F:=op(f,3);
q:=(if F::constructor=Dom::GaloisField then
         F::size
    elif F::constructor=Dom::IntegerMod then
         F::characteristic
    else
	 infinity
    end_if
    );

ff:=gcd(f,D([1],f));
if degree(ff)>0 then 
	return(append(faclib::multihensel(divide(f,ff,hold(Exact))),ff));
end_if;

R:=Dom::DistributedPolynomial([op(iindets,2..nindets)],F);
evpoints:=array(2..nindets);
// try whether zero is good evaluation point 
f0:=evalp(f,iindets[i]=F::zero $i=2..nindets);
ff:=Factored::convert_to( polylib::sqrfree(f0),DOM_LIST );
if degree(f0)=degree(f,X) and nops(ff)=3 and op(ff,3)=1 then
	for i from 2 to nindets do
	 	evpoints[i]:=F::zero; 
	end_for;
	userinfo(2,"Zero is suitable evaluation point");
	ff:=poly(f,[X],R);
elif nindets>2 or 
    q > 3*degree(f,X) then
	st:=time();
	repeat
		for i from 2 to nindets do
			evpoints[i]:=F::random();
		end_for;
		f0:=evalp(f,iindets[i]=evpoints[i] $i=2..nindets);
		ff:=Factored::convert_to( polylib::sqrfree(f0),DOM_LIST );
	until degree(f0)=degree(f,X) and nops(ff)=3 and op(ff,3)=1 end_repeat;
	userinfo(2,"Time needed for choosing evaluation points:".expr2text(time()-st));

	ff:=poly(subs(expr(f),iindets[i]=iindets[i]+expr(evpoints[i])
 	$i=2..nindets),	[X],R);
else  // small finite field 
	st:=time();
	a:=FALSE;   // evaluation point found ? 
        for i from 1 to 10 do // some tries first 
		evpoints[2]:=F::random();
		f0:=evalp(f,iindets[2]=evpoints[2]);
		if degree(f0)=degree(f,X) then
			ff:=Factored::convert_to( polylib::sqrfree(f0),DOM_LIST );
			if nops(ff)=3 and op(ff,3)=1 then
				a:=TRUE;
				userinfo(3,"Found evaluation point by random
					choice in ".expr2text(i)."th try");
				userinfo(3,"Evaluation point is ".expr2text(
					 evpoints[2]));
				break;
			end_if;
		end_if; 
	end_for;
	if a=FALSE then
		ff:=poly(f,[X],R);
	 	a:=lcoeff(ff);
	 	y:=op(iindets,2);

		df:=polylib::Dpoly(ff);
	 	g:=polylib::resultant(ff,df);
     
		g:=g*a;
     
                /* as y^q-y is the product of all linear polynomials,
                  (y^q-y)/g is the product
                   of all (y-c) where c runs through all suitable
                   evaluation points; they can be found by factoring */

		j:=0;
		repeat
			j:=j+1;
			h:=R(y^(q^j)-y);
			h:=divide(h,gcd(g,h),hold(Exact));
		until degree(h)>0 end_repeat;


                // only non-roots of a remain 

		if j>1 then 
                // bad luck : there is no good evaluation point 
                // field has to be extended 
        
                	userinfo(2,"Field does not contain good evaluation point");
                	userinfo(2,"Constructing extension of degree",j);
                
                	f:=poly(f,Dom::GaloisField(F,j));
                	h:=faclib::multihensel(f);
			// multiply conjugates 
		        g:=[];
			repeat
				l:=poly(1,op(f,2..3));
				userinfo(5,"Collecting conjugates of ".
					expr2text(h[1]));
				repeat 
					l:=l*h[1];
					h[1]:=mapcoeffs(h[1],_power,q);
					i:=contains(h,h[1],2);	
					if i<>0 then delete h[i] end_if;
				until i=0 end_repeat;
				delete h[1];
				g:=append(g,l);	
			until h=[] end_repeat;
                	for i from 1 to nops(g) do
				g[i]:=subsop(op(g,i),3=F);
			end_for;
                	return(g);
        	else     
			userinfo(3,"Number of good evaluation points: "
				.expr2text(degree(h)));
			if degree(h) > q/4 then  
				// many good points, try random choice  
				repeat 
					evpoints[2]:=F::random()
				until evalp(h,y=evpoints[2])=F::zero end_repeat;
				userinfo(3,"Found evaluation point by random
					 choice");
				userinfo(3,"Evaluation point is ".
					expr2text(evpoints[2]));
			else    
                		h:=faclib::eqdegr(poly(h,[y],F),1,1);
                		evpoints[2]:=-coeff(h,0);
				userinfo(3,"Choosing evaluation point: "
				.expr2text(evpoints[2]));
                		/* simply choose the first
				 factor found (anyone would be o.k) */
			end_if;
		end_if;
	end_if;
	f0:=evalp(f,iindets[2]=evpoints[2]);
	ff:=poly(subs(expr(f),iindets[2]=
		iindets[2]+expr(evpoints[2])
 		),	[X],R);

end_if;
lc:=lcoeff(ff);
st:=time();
fi:=factor(f0);
fi:=Factored::convert_to(fi,DOM_LIST);
userinfo(2,"Time for univariate factorization:".expr2text(time()-st));
if nops(fi)=3 then 
	userinfo(2,"Even homomorphic image is irreducible");
	return([f]); 
else
	userinfo(2,"Homomorphic image has "
		.expr2text(nops(fi) div 2)." factors");
end_if;
t:=op(fi,1);
fi:=[op(fi,2*j) $j=1..nops(fi) div 2];
fi[1]:=multcoeffs(fi[1],t);
// find s1 ... sn 

/* if u*(f1*..fk)+v*(f(k+1))=1 and s1*(f2* ...*fk)+ ... + sk*(f1*...*f(k-1))=1
  then set s(k+1):=u and multiply the other si by v */

st:=time();
fprod:=fi[1]*fi[2];
t:=gcdex(fi[2],fi[1]);  // sic! 
s:=[ op(t,2..3) ];
// loop invariant: fprod = f1 * ... * fj 
for j from 3 to nops(fi) do 
	t:=gcdex(fprod,fi[j]);
	for k from 1 to j-1 do
		s[k]:=s[k]*op(t,3);
	end_for;
	s:=append(s,op(t,2)); 
	fprod:=fprod*fi[j];
end_for;
 s:=zip(s,fi,proc() begin divide(args(1),args(2),hold(Rem)) end_proc ); 

userinfo(2,"Time for determining the si: ".expr2text(time()-st));

// transform to polynomials over R 
for j from 1 to nops(fi) do 
	fi[j]:=poly(fi[j],[X],R);
	s[j]:=poly(s[j],[X],R);
end_for;

d:=max(map(coeff(ff),degree))+1;
userinfo(2,"Lifting up to order ".expr2text(d));
st:=time();
for j from 2 to d do
		userinfo(3,"Lifting to order ".expr2text(j));
		e:=mapcoeffs(ff-_mult(op(fi)),proc() begin faclib::truncate(args(1),j) end_proc );  
	for i from 2 to nops(fi) do 
		q[i]:=divide(e*s[i],fi[i]);
		r[i]:=mapcoeffs(op(q[i],2),proc() begin faclib::truncate(args(1),j) end_proc );
		q[i]:=mapcoeffs(op(q[i],1),proc() begin faclib::truncate(args(1),j) end_proc );
		fi[i]:=fi[i]+r[i];
	end_for;
	// i = 1 
	r[1]:=mapcoeffs(s[1]*e+fi[1]*(_plus(q[k] $k=2..nops(fi))),
		proc() begin faclib::truncate(args(1),j) end_proc );
	fi[1]:=fi[1]+r[1];
end_for;
userinfo(2,"Time for Hensel lifting: ".expr2text(time()-st));

userinfo(3,"Result of lifting:",fi);	

// try to combine operands of fi to obtain a factorization 

factorsleft:=[op(fi,2..nops(fi))];
factlist:=[];

repeat
	r:=faclib::tryall(ff,factorsleft,lc,d);
	if r=FAIL then
		factorsleft:=[];
	else
		factlist := append(factlist,op(r,1));
		userinfo(2,"Factor found:",op(r,1));
		ff:=divide(ff,op(r,1),hold(Exact));
		if ff=FAIL then error("factor not correct"); end_if;
		setleft:= {$1..nops(factorsleft)} minus op(r,2);
		factorsleft:=[op(factorsleft,op(setleft,j))
		 $j=1..nops(setleft)];
	end_if
until factorsleft=[] end_repeat;
if factlist=[] then 
	return([f])
else
   	factlist:=append(factlist,ff); 
	return(map(factlist,proc() begin poly(subs(expr(args(1)),
		iindets[i]=iindets[i]-expr(evpoints[i]) $i=2..nindets),
		op(f,2..3)) end_proc ));
end_if
end_proc:


faclib::tryall:=proc(f,flist,lc,d)
/* tests whether multiplying some members flist
  and lc modulo I^d 
  gives a factor of f */
/* returns a factor that can be obtained this way, and a set
  containing the indices of those operands of flist that were used to build up
  this factor, or FAIL */
local g,gg,h,i,j,l;

begin
userinfo(4,"faclib::tryall called with",flist);
l:={op(combinat::powerset({$1..nops(flist)}))} minus {{}};
l:=sort([op(l)],proc() begin nops(args(1))<nops(args(2)) end_proc );
	// now l is the list of subsets of 1..nops(flist), sorted by size 
for j from 1 to nops(l) do
	userinfo(5,"Trying subset ".expr2text(l[j]));
	h:=mapcoeffs(multcoeffs(_mult(flist[op(l[j],i)] $i=1..nops(l[j])),
	lc),proc() begin faclib::truncate(args(1),d) end_proc );
	g:=polylib::primpart(h);
// try to divide trailing coefficients first 
	gg:=coeff(f,op(f,[2,1]),0)/coeff(g,op(f,[2,1]),0); 
	if gg<>FAIL then
		gg:=divide(f,g,hold(Exact))
	else
		userinfo(5,"FAIL on division of trailing coefficients")
	end_if;
	if gg<>FAIL then
		// factor found 
	return([g,l[j]]);
	end_if
end_for;
FAIL
end_proc:
