//    

// kg, 16/12/94 

/*++
faclib::pre_factor -- split trivial factors apart

faclib::pre_factor(p)

p - polynomial

faclib::pre_factor(p) returns a list [c,f1,e1,...,fn,en] such that
p = c*f1^e1*...*fn^en. c is the contents of p, the factors fi may have 
less indets that p.

faclib::pre_factor removes unused unknowns and splits apart factors
of the form x^k and the contents of p with respect to each unknown 
xi in turn.
++*/

faclib::pre_factor:=
proc(pp)
  local i, p, d, f, q, x, X, T, k, l;
begin
    p:=pp; // to avoid warnings 
    X:= op(p,2);
    T:= op(p,3);

    if iszero(p) then
      return([tcoeff(p)])
    end_if;
    // remove contents 
    f:= content(p);
    if domtype(T) = DOM_DOMAIN then
    	p:= mapcoeffs(p, T::_divide, f)
    else
    	p:= multcoeffs(p, 1/f)
    end_if;

    if degree(p) = 0 then return([lcoeff(p)*f]) end_if;
    f:= [f];
    
    // remove factors of the form x^d 
    if ldegree(p) <> 0 then
    	for x in X do
    	    d:= ldegree(p,x);
    	    if d <> 0 then
    	    	q:= poly(x, [x], T);
    	    	p:= divide(p, poly(q,X,T)^d, Exact);
    	    	f:= append(f, q, d);
    	    end_if;
    	end_for;
    end_if;
    
    if degree(p) = 0 then 
        return(subsop(f, 1=f[1]*lcoeff(p)))
    end_if;
    if nops(X) = 1 then return(append(f, p, 1)) end_if;

    // remove unused indets 
    X:= select(X, proc() begin bool(degree(p, args(1)) <> 0) end_proc );
    p:= poly(p, X);
    if nops(X) = 1 then return(append(f, p, 1)) end_if;

    // view p as polynomial in X[i] and remove content 
    for i from 1 to nops(X) do
	l:=[coeff(p,X[i],k) $k=0..degree(p,X[i])];
	q:=gcd(op(l));
	if degree(q) <> 0 then
	    p:= divide(p, poly(q,X,T), Exact);
	    q:= faclib::pre_factor(q);
	    f[1]:= f[1] * q[1];
	    f:= f . subsop(q, 1=null())
	end_if
    end_for;
    
    // remove unused indets 
    if degree(p) = 0 then 
        return(subsop(f, 1=f[1]*lcoeff(p)))
    end_if;
    X:= select(X, proc() begin bool(degree(p, args(1)) <> 0) end_proc );
    append(f, poly(p, X), 1)
end_proc:

// end of file 
