/*--
faclib::roots -- return the roots of an univariate polynomial in Zp,
                 that is the roots of the linear factors of a

faclib::roots(a)
a - an univariate polynomial in Zp
--*/

faclib::roots :=
proc(a)
  local x,p,l,i,f,g,X,res,m;
  option remember;
begin
  x:=op(a,[2,1]); p:=op(a,[3,1]);
  l:=faclib::sqrfreeff(a,x,p);
  X:=poly(x,[x],IntMod(p));
  res:=null();
  for i from 1 to nops(l)/2 do
    f:=op(l,2*i-1); m:=op(l,2*i); // multiplicity
    g:=gcdlib::univ_mod_gcd(f,faclib::powermod_poly(X,p,f)-X);
    if degree(g)=1 then
         // be careful because the result of univ_mod_gcd is not normalized 
      res:=res,(-coeff(g,0)/coeff(g,1) mod p)$m
    elif degree(g)>1 then
      if p=2 then
        f:=faclib::canzas_2(g,1,x)
      else
        f:=faclib::canzas_lin(g,p,x)
      end_if;
         // here the output of canzas_lin is normalized 
      for g in f do
        res:=res,(-coeff(g,0) mod p)$m
      end_for
    end_if
  end_for;
  res
end_proc:
