/*--
faclib::sqrfreeff -- return the square free factorization of a monic univariate
                     polynomial in Zp, the algorithm comes from page 345 of
                     Algorithms for computer algebra, page 345, written by Keith
                     O. Geddes, Stephen R. Czapor and George Labahn, published
                     by Kluwer Academic Publishers in 1992.  Output is given in
                     form [f1,e1,...,fn,en], a=f1^e1*..*fn^en in Zp.

faclib::sqrfreeff(a,x,p)
a - a monic univariate polynomial in Zp
x - the indeterminate
p - the prime number
--*/

faclib::sqrfreeff:=proc(a,x,p)
local b, c, i, j, sq, w, y, z;
begin
    b:=polylib::Dpoly([1],a); // diff(a,x) 
    if iszero(b) then
       a:=faclib::sqrfreeff(poly(subs(expr(a),x=_power(x,1/p)),IntMod(p)),x,p);
       return(subsop(a,((2*j)=op(a,2*j)*p)$j=1..nops(a)/2));
    else i:=1;  
         sq:=[];
         c:=faclib::univ_mod_gcd(a,b);
         w:=divide(a,c,Exact);
         while expr(w)<>1 do
               y:=faclib::univ_mod_gcd(w,c);
               z:=divide(w,y,Exact);
               if degree(z)>0 then 
                  sq:=append(sq,z,i);
               end_if;
               i:=i+1;
               w:=y;
               c:=divide(c,y,Exact);
        end_while;
        if expr(c)<>1 then 
           c:=faclib::sqrfreeff(poly(subs(expr(c),x=_power(x,1/p)),\
                                     IntMod(p)),x,p);
           return(sq.subsop(c,((2*j)=op(c,2*j)*p)$j=1..nops(c)/2));
        end_if;
    end_if;
    return(sq);
end_proc:

