//    

// kg, 27/07/94 

/*--
expr2polys -- convert arguments to polynomials of common type

expr2polys(l [, T])

l - list of expressions
T - type expression or domain (default is Type::AnyType)

expr2polys returns a list of polynomials with a common list of indets
and coefficient ring 'Expr' where the coefficients are of type T.
expr2polys returns FAIL if the expression are no polynomial expressions
or the coefficient type is wrong.
--*/

gcdlib::expr2polys:=
proc(ll, T)
  local X, l, t;
begin
    // get polynomial indets 
  X:= indets(ll, hold(PolyExpr));
  t:= indets(X, hold(RatExpr));
  X:= [ op((X intersect t) minus indets(X minus t, hold(RatExpr))) ];
  if X = [] then
    // try normalizing 
    l:= map(ll, normal);
    X:= indets(l, hold(PolyExpr));
    t:= indets(X, hold(RatExpr));
    X:= [ op((X intersect t) minus indets(X minus t, hold(RatExpr))) ];
    if X = [] then
      return(FAIL)
    end_if;
    t:= map(l, poly, X, hold(Expr));
  else
    l:=ll;
    t:= map(l, poly, X, hold(Expr));
    if contains(t, FAIL) <> 0 then
      // try normalizing 
      t:= map(map(l, normal), poly, X, hold(Expr));
    end_if
  end_if;
  if contains(t, FAIL) <> 0 then
    return(FAIL)
  end_if;
  
  // test coeff types 
  if args(0) = 2 then
    if contains(map(map(t, coeff), testtype, T), FALSE) <> 0 then
      return(FAIL)
    end_if;
  end_if;
  t
end_proc:

// end of file 
