
/*
gcdlib::gcdNumeric(f1, ..., )

computes the gcd of the univariate polynomials f1, ... over \C[x]
that is, identifiers in the coefficients are understood as (unknown)
numbers and not as indeterminates in the algebraic sense
Consequently, a case analysis depending on these identifiers may be necessary


*/
gcdlib::gcdNumeric:=
proc(): Type::Union(piecewise, DOM_POLY)
  local
  argv: DOM_LIST,
  vars: DOM_SET,
  reduce: DOM_PROC,
  gcdOfTwo: DOM_PROC;

begin


  reduce:=
  proc(f)
    local r;
  begin
    if iszero(f) then
      f
    else
      r:= f - lmonomial(f);
      piecewise([lcoeff(f) <> 0, multcoeffs(f, 1/lcoeff(f))],
                [lcoeff(f) = 0, reduce(r)]
                )
    end_if
  end_proc;

  /*
     gcdOfTwo - compute the gcd of two polynomials
  */
  gcdOfTwo:=
  proc(f: DOM_POLY, g: DOM_POLY): Type::Union(piecewise, DOM_POLY)
    local r, lc;
  begin
    if iszero(g) then
      reduce(f)
    else
      r:= g - lmonomial(g);
      lc:= numer(lcoeff(g));
      g:= multcoeffs(g, 1/lcoeff(g));
      piecewise([lc <> 0, gcdOfTwo(g, mapcoeffs(divide(f, g, Rem), normal))],
                [lc = 0, gcdOfTwo(f, r)])
    end_if
  end_proc;



  // m a i n    p r o g r a m

  argv:= [args()];

  if testargs() then
    if nops(argv) = 0 then
      error("gcdNumeric called without arguments")
    end_if;

    if map({op(argv)}, domtype) <> {DOM_POLY} then
      error("Polynomials expected")
    end_if;

    vars:= map({op(argv)}, op, 2);
    if nops(vars) > 1 or nops(op(vars, 1)) > 1 then
      error("Polynomials must be univariate in the same variable")
    end_if;

  end_if;

  // it is best to compute the gcd of small polys first
  argv:= sort(argv, (f, g) -> degree(f) <= degree(g));



  // replace (a1, a2) by gcd(a1, a2) in the argument list
  // at any moment, argv[1] may be a piecewise but all other entries
  // are polynomials
  while nops(argv) > 1 do
    argv[1]:= piecewise::extmap(argv[1], gcdOfTwo, argv[2]);
    delete argv[2]
  end_while;

  argv[1]

end_proc:
