



gcdlib::gcdexEuclidean:=
proc(A: DOM_POLY, B: DOM_POLY, x)
  local a, b, s, t, u, v, q, tmp;
begin
   a:= A; b:= B;
   s:=a^0; t:=s-s; u:=t; v:=s;
   // loop invariant : a = s*A+t*B, b = u*A+v*B
  while not iszero(b) do
    userinfo(10, "Applying Euclidean step");
    q:=divide(a,b);
    if q = FAIL then
       error("Could not divide");
    end_if;
    userinfo(10, expr2text(a)." = ".expr2text(b)."*".expr2text(q[1]).
             " + ".expr2text(q[2]));
    a:=b;
    b:= q[2];
    q:= q[1];
    tmp:=s; s:=u; u:=tmp-q*u;
    tmp:=t; t:=v; v:=tmp-q*v;
    userinfo(10, expr2text(a)." = ".expr2text(s). "*". expr2text(A).
             " + ".expr2text(t)."*".expr2text(B))
  end_while;
  tmp:=1/lcoeff(a);
  userinfo(20, "Normalizing ");
  multcoeffs(a,tmp), multcoeffs(s,tmp), multcoeffs(t,tmp);
end_proc:


// end of file