


gcdlib::gcdexExpr:=
proc(A: Type::Arithmetical, B: Type::Arithmetical, x)
  local result, conta, contb, opA, opB, a, b, common, dummy;
begin
  
  if iszero(A) then
    if iszero(B) then
      return(0, 0, 1)
    else
      return(B/lcoeff(B, [x]), 0, lcoeff(B))
    end_if;
  end_if;
  
  if iszero(B) then
    conta:= lcoeff(A, [x]);
    return(A/conta, 1/conta, 0)
  elif not has(B, x) then
    return(1, 0, 1/B)
  elif not has(A, x)then
    return(1, 1/A, 0)
  end_if;
    
    
    // Usually, we can *not* use the fact if A and B are products at this point.
    // However, we can remove common factors and constant factors
    
  if type(A) = "_mult" then 
    [opA, conta, dummy]:= split({op(A)}, has, x);
    conta:= _mult(op(conta));
  else
    opA:= {A};
    conta:= 1
  end_if;
    
  if type(B) = "_mult" then
    [opB, contb, dummy]:= split({op(B)}, has, x);
    contb:= _mult(op(contb));
  else
    opB:= {B};
    contb:= 1
  end_if; 
    
    // now A = conta * _mult(op(opA)), B = contb * _mult(op(opB))
    
  common:= opA intersect opB;
  if nops(common) > 0 then
    opA:= opA minus common;
    opB:= opB minus common
  end_if;      
    
  a:= poly(_mult(op(opA)), [x]);
  b:= poly(_mult(op(opB)), [x]);
  if a=FAIL or b=FAIL then
    error("Could not convert input to polynomials in the given variable")
  end_if;
    
  result:= map(gcdlib::gcdexPoly(a, b, x), expr);
   
  if nops(common) = 0 then
    op(result, 1), op(result, 2)/conta, op(result, 3)/contb
  else
    op(result, 1)* _mult(op(common)), op(result, 2)/conta, op(result, 3)/contb
  end_if;      
  
end_proc:  
  