gcdlib::gcdexPoly:=
proc(A: DOM_POLY, B: DOM_POLY, x)
  local a, b, coeffs, T, y, aa, bb, result;
begin
  if op(A, [3, 0]) = IntMod and not isprime(op(A, [3, 1])) then
    // we have to exit here immediately, since we must not divide by the leading coefficient
    return(gcdlib::gcdexModComposite(A, B, x))
  end_if;
  
  
  T:= op(A, 2..3);  
  
  if iszero(A) then
    if iszero(B) then
      return(A, A, poly(1, T))
    else
      bb:= lcoeff(B);
      return(multcoeffs(B, 1/bb), poly(0, T), poly(1/bb, T))
    end_if
  end_if;
  
  if iszero(B) then
    aa:= lcoeff(A);
    return(multcoeffs(A, 1/aa), poly(1/aa, T), B)
  elif degree(B) = 0 then
    return(poly(1, T), poly(0, T), poly(1/coeff(B, 0), T))
  elif degree(A) = 0 then
    return(poly(1, T), poly(1/coeff(A, 0), T), poly(0, T))
  end_if;
  
  
  // it is better to handle degree(A) < degree(B) immediately than to interchange them in every algorithm
  if degree(A) < degree(B) then 
    result:= gcdlib::gcdexPoly(B, A, x);
    return(op(result, 1), op(result, 3), op(result, 2))
  end_if;  
  
  
  a:= A;
  b:= B;

 

  // we have to handle three kinds of polynomials: over Expr, over IntMod, and over domains  
  if op(a, 3) = Expr then
   
    assert(not iszero(a));
    assert(not iszero(b));   
    
    coeffs:= {coeff(a), coeff(b)};
    // handle special case of rational polynomials separately
    if map(coeffs, domtype) minus {DOM_INT, DOM_RAT} = {} then
      return(gcdlib::gcdexRational(a, b))
    end_if;
 
    if degree(B) >= 3 then
      y:= indets(coeffs, PolyExpr);
      if nops(y) = 1 then
        // experimentally, modular algorithms are slower if there is more
        // than one additional variable 
        y:= op(y, 1);
        if type(y) <> "_power" 
        // we want to avoid indeterminates of the form 1/X
        and min(degree(A), degree(B)) > degree(A, [y]) + degree(B, [y]) then
          aa:= poly(a, [x, y]);
          bb:= poly(b, [x, y]);
          if map({coeff(aa), coeff(bb)}, domtype) minus {DOM_INT, DOM_RAT} = {} then 
            // does not work for complex numbers and floats!
            return(gcdlib::gcdexModular(aa, bb, x, [x, y]))
          end_if  
        end_if;
      
      end_if;  
    end_if; 

    return(gcdlib::gcdexPrimitive(a, b, x))
    
  elif op(a, 3) = Dom::Rational then
    return(op(map([gcdex(poly(a, Expr), poly(b, Expr))], poly, Dom::Rational)))
  end_if;
 
  // default
  gcdlib::gcdexEuclidean(a, b, x)
  
end_proc: