/*
   gcdlib::greatestCommonMonomial - returns the greatest monomial that
   divides both a and b

   extracted from gcdlib::special_cases, originally written by  KD

*/

gcdlib::greatestCommonMonomial:=
proc(a: DOM_POLY, b: DOM_POLY)
  local ma, mb, f, X, n, T, i;
begin
  X:= op(a,2);
  n:= nops(X);
  T:= op(a,3);

// ldegree(xi) > 0 ?
  ma:= [ ldegree(a, X[i]) $ i=1..n ];
  if _plus(op(ma)) <> 0 then
    mb:= [ ldegree(b, X[i]) $ i=1..n ];
    if _plus(op(mb)) <> 0 then
      f:= zip(ma, mb, min);
      if _plus(op(f)) <> 0 then
        return(poly(_mult(op(zip(X, f, _power))), X, T))
      end_if
    end_if
  end_if;
  a^0
end_proc:

// the following version turns out to be slower due to conversion overhead:
/*
proc(a, b)
  local l, k, minexpo;
begin
  // list of all exponent vectors
  l:= map(poly2list(a), op, 2).map(poly2list(b), op, 2);
  k:= nops(op(a, 2));
  // get minimums
  minexpo:= [min(map(l, op, i)) $i=1..k];
  poly([[1, minexpo]], op(a, 2..3))
end_proc:
*/
