
/*--
gcdlib::special_cases(a, b, gcdp, normp)

a, b        - polynomials
gcdp, normp - procedures

Computes the gcd of a and b. At first some special cases are handled.
Only if necessary the 'real' gcd routine 'gcdp' is called. 'normp' is
used to normalize the result if a divides b or vice versa.
--*/

gcdlib::special_cases:=
proc(aa, bb, gcdp, normp)
  local a, b, n, da, db, ma, mb, i, j, x, g, T, X, Xn, S, f, doScale, constgcd, coeffvec;
begin
  a:=aa;
  b:=bb;  // to avoid warnings
  userinfo(3, "gcdlib::special_cases called with ".expr2text(a)." and ".
           expr2text(b));
  X:= op(a,2);
  n:= nops(X);
  T:= op(a,3);

  if type(T) = DOM_DOMAIN then
    constgcd:= T::gcd
  elif T = Expr then
    constgcd:= gcd
  else
    constgcd:= 1
  end_if;

  // extract monomial factors
  // ldegree(xi) > 0 ?
  ma:= [ ldegree(a, X[i]) $ i=1..n ];
  if _plus(op(ma)) <> 0 then
    a:= divide(a, poly(_mult(op(zip(X, ma, _power))), X, T), Exact);
  end_if;
  mb:= [ ldegree(b, X[i]) $ i=1..n ];
  if _plus(op(mb)) <> 0 then
    b:= divide(b, poly(_mult(op(zip(X, mb, _power))), X, T), Exact);
  end_if;
  f:= zip(ma, mb, min);
  if _plus(op(f)) <> 0 then
    userinfo(5, "Simple divisor ".expr2text(f)." found");
    f:= poly(_mult(op(zip(X, f, _power))), X, T)
  else
    f:= a^0
  end_if;


  if degree(b)=0 then
    return(f * normp(poly(content(b), X, T), a))
  elif degree(a)=0 then
    return(f * normp(poly(content(a), X, T), b))
  end_if;

  // substitution x -> x^(1/g) possible?
  if n = 1 then
    da:= [[ degree(nthterm(a,j)) $ j=1..nterms(a) ]];
    db:= [[ degree(nthterm(b,j)) $ j=1..nterms(b) ]];
  else
    da:= [ degreevec(nthterm(a,j)) $ j=1..nterms(a) ];
    db:= [ degreevec(nthterm(b,j)) $ j=1..nterms(b) ];
    da:= [ map(da, _index, j) $ j=1..n ];
    db:= [ map(db, _index, j) $ j=1..n ];
  end_if;

  S:= zip(da, db, proc()
                  begin
                    max(1, igcd(0, op(args(1)), op(args(2))))
                  end_proc );
  doScale:= bool(select(S, _equal, 1) <> S);
  if doScale then
    userinfo(5, "Scaling input");
    g:= map(S, 1/id);
    a:= stdlib::scale_exp(a, g);
    b:= stdlib::scale_exp(b, g);
  end_if;

  userinfo(5, "Reducing to common indets with positive degree");   
  g:= map([ min(degree(a, X[j]), degree(b, X[j])) $ j=1..n ], _equal, 0);
  Xn:= [ (if g[j] then null() else X[j] end_if) $ j=1..n ]; // variables the gcd may depend on
  x:= [ (if g[j] then X[j] else null() end_if) $ j=1..n ];  // other variables

  if Xn = [] then
    g:= poly(constgcd(coeff(a), coeff(b)), X, T);
    if doScale then 
      g:= stdlib::scale_exp(g, S)
    end_if;
    return(f*g)
  end_if;

  if Xn <> X then 
    // use simple method without polylib::Poly 
    coeffvec:= [coeff(a, x[1], i) $i=0..degree(a, x[1]),
                  coeff(b, x[1], i) $i=0..degree(b, x[1])
                 ];
    for j from 2 to nops(x) do
       coeffvec:= map(coeffvec, F -> coeff(F, x[j], i) $i=0..degree(F, x[j]))
    end_for;
    g:= poly(gcd(op(coeffvec)), X, T);
    if doScale then 
      g:= stdlib::scale_exp(g, S)
    end_if;
    return(f*g)         
  end_if;
  
 
  g:= gcdp(a, b);


  if doScale then
    f:= f * stdlib::scale_exp(g, S);
  else
    f:= f * g
  end_if;
  f;
end_proc:


// end of file 
