//    

// kg, 09/12/93 

/*--
gcdlib::vanderm_mod_solve -- solve transpose Vandermonde system over Zp

gcdlib::vanderm_mod_solve(A,b,p)

A - list of coefficients of transpose Vandermonde matrix
b - list of right hand sides
p - modulus

gcdlib::vanderm_mod_solve solves a linear transpose Vandermonde system
over Zp. The transpose Vandermonde System is given by 

    A[1]^j * x[1] + ... + A[n]^j * x[n] = b[j+1], j=0..n-1

The algorithm is given by Zippel in his book "Effective Polynomial Computation", p.213.
--*/


gcdlib::vanderm_mod_solve:=
proc(A: DOM_LIST, b: DOM_LIST, p: DOM_INT)
  local n, x, i, j, vpl, vpj, vpprod, z;
begin

  z := `#z`;
  n:= nops(A);

  if n = 1 then
    return([b[1]])
  end_if;

  // the system is solvable iff the coefficients are distinct
  if nops({op(A)}) <> n then
    return(FAIL)
  end_if;

  vpl:= [ poly(z-A[i],[z],IntMod(p)) $ i=1..n ];

  vpprod:= _mult(op(vpl));
  
  x:= [FAIL $n];
  for j from 1 to n do
    vpj:= divide(vpprod, vpl[j], Exact);
    vpj:= multcoeffs(vpj, 1/evalp(vpj, z=A[j]));
    x[j]:= _plus(op(map(zip(b, [coeff(vpj, All)], _mult), modp, p))) mod p
  end_for;
  x
end_proc:

// end of file 
