
/*

  polylib::multivariateResultant(p, q, x)

  p, q - multivariate polynomials of the same type
     x - one of the variables in op(p, 2)

  Returns the resultant of p and q with respect to x.

   This is *not* the multivariate resultant with respect to several variables
   as defined in the literature on algebraic geometry
*/

polylib::multivariateResultant:= 
proc(p: DOM_POLY, q: DOM_POLY, x)
  local T, vars, R;
begin 
  R:= op(p, 3);
  if R = hold(Expr) then
    // we use CPRES; then CPRES itself calls other algorithms if necessary
    return(polylib::CPRES(p, q, x))
  end_if;  
  vars:= select(op(p, 2), _unequal, x);
  if op(R, 0) = IntMod and not isprime(op(R, 1)) then
    // the Euclidean algorithm will not work in general
    // but we can always set up a Sylvester matrix
    T:= Dom::DistributedPolynomial(vars, Dom::IntegerMod(op(R, 1)));
    poly(linalg::det(linalg::sylvester(poly(p, [x], T), poly(q, [x], T), x)), vars, R)
  else
    T:= polylib::Poly(vars, R);
    polylib::euclideanResultant(poly(p, [x], T), poly(q, [x], T), x, T::_divide)
  end_if
end_proc:

// end of file