/*

   polylib::rationalResultant(f, g, x)

   f, g - univariate polynomials in x, with rational coefficients
      x - variable

   returns the resultant of f and g

*/

polylib::rationalResultant:=
proc(f: DOM_POLY, g: DOM_POLY, x)
  local cf, cg, resultsize, result;
begin
  cf:= icontent(f);
  cg:= icontent(g);  
  f:= multcoeffs(f, 1/cf);
  g:= multcoeffs(g, 1/cg);
  // now f and g are integer polynomials

  // By vzG/Gerhard, Theorem 6.23, the bit length of the result is bounded as follows
  // This bound proves to be rather sharp in practice. 
  resultsize:= degree(g)*log(2, norm(f, 2)) + degree(f)*log(2, norm(g, 2));
  userinfo(25, "Expected size of resultant:", resultsize);
  // Experiments suggest the following bound for changing from modular to Euclidean resultant
  if resultsize * degree(g) > 1.6e6 then 
    result:= polylib::CRES(f, g, resultsize)
  else 
    result:= polylib::euclideanResultant(f, g, x, _divide)
  end_if;  

  cf^degree(g) * cg^degree(f) * result
end_proc:

// end of file