/**
   Extract the coefficient ring of a polynomial or domain 
   in a uniform way
**/

polylib::coeffRing :=
proc(p //: Type::Union(Type::Polynomial, Type::PolynomialDomain)
    )
    : DOM_DOMAIN
    local result;
begin
    case domtype(p)
      of DOM_POLY   do result := op(p,3); break;
      of DOM_DOMAIN do result := p::coeffRing; break;
      otherwise        result := p::dom::coeffRing;
    end_case;
    if domtype(result) = DOM_DOMAIN then
	return(result);
    elif result = Expr then
	return(Dom::ExpressionField());
    else
	assert(domtype(result)=DOM_EXPR and
	       op(result,0)=IntMod and
	       nops(result)=1);
	Dom::IntegerMod(op(result,1));
    end_if;
end_proc:
