/*++
	cyclotomic(n,x) 

	computes the n-th cyclotomic polynomial, expressed
	in the indeterminate x

++*/


polylib::cyclotomic:=
proc(n: Type::PosInt, x: DOM_IDENT)
 local divs: DOM_LIST,
  pos: DOM_LIST,
  neg: DOM_LIST,
  d:   DOM_INT;
begin
  if n = 1 then return(poly(x - 1, [x])); end_if;
  divs:= numlib::divisors(n);
  pos:= select(divs, d -> numlib::moebius(n/d) = 1);
  neg:= select(divs, d -> numlib::moebius(n/d) = -1);
  divide(poly(_mult(poly(1 - x^d, [x]) $d in pos), [x]),
         poly(_mult(poly(1 - x^d, [x]) $d in neg), [x]),
         Exact)
end_proc: 

