// returns a set of all divisors of p 
polylib::divisors :=
proc(p)
  local makeProducts, w, result, i, j;
begin
  if testargs() then
    if args(0) <> 1 then
      error("expected one argument in function call")
    elif not (domtype(p) = Factored or domtype(p) = DOM_POLY or 
              p::dom::hasProp(Cat::Polynomial) = TRUE  or 
              poly(p) <> FAIL) then
	    error("argument must be of type polynomial")
    end_if
  end_if;
  
  makeProducts := proc(a,b)
  begin 
    map(a, (x,y) -> op(map(y, (z1, z2) -> expand(_mult(z1,z2)), x)), b)
  end_proc;
  
  if domtype(p) = Factored  then
      // Anpassung an Umstellung von Factored::_index (Walter 29.12.04)
      w := coerce(p, DOM_LIST);
      p := w[2]
  else
      w:=factor(p)
  end_if;
  result := [p^0];
  for i from 1 to (nops(w)-1)/2 do
      [op(w,2*i)^j $ j = 1..op(w,2*i+1)];
      result := append(result, op(makeProducts(%,result)));
  end_for;
  {op(result)}
end_proc:
