//    


// Astrid Wiemeyer, 1997 

/*
    
   polylib::primitiveElement(K1, K2)

   K1 - algebraic extension K(alpha) for some K
   K2 - algebraic extension K1(beta)

   returns a list of

   - an algebraic extension K(gamma) that is K-isomorphic
     to K2

   - an identifier (the primitive element gamma)

   - alpha expressed in terms of gamma

   - beta expressed in terms of gamma

*/
   

polylib::primitiveElement :=
proc(K1,K2)

  local erzp1, erzp2, az_1, az_2, az_3, sgR, K3, ausdr, ggt, unb1,
      base_field;

begin
   // 0. Teil: Eingabeueberpruefung 

   if testargs() then
      if args(0) <> 2 then
         error("Two arguments expected!");
      end_if;
      if (K1::hasProp(Dom::AlgebraicExtension) <> TRUE)  or
         (K2::hasProp(Dom::AlgebraicExtension) <> TRUE) then
         error("Algebraic Extensions are expected!");
      end_if;
      if K2::groundField <> K1 then
         error("The second argument has to be an Algebraic /
                Extension over the first argument!");
      end_if;
   end_if;

   /* 1. Teil: Bestimmung des irreduziblen Polynoms ueber Q, dessen 
              Nullstelle das gesuchte primitive Element ist..
   */
   base_field := K1::groundField;
   erzp1      := K1::minpoly;
   erzp2      := K2::minpoly;
   az_1       := op(erzp1,[2,1]);
   az_2       := op(erzp2,[2,1]);
   sgR        := polylib::sqrfreeNorm(erzp2);
   
   /* 2. Teil: Darstellung der erzeugenden Elemente von K1 und K2 
              als Ausdruecke im ermittelten primitiven Element
              Das Minimalpolynom des primitiven Elementes ist sgR[2]
   */ 
   az_3   := genident();   
   unb1   := genident();
   ausdr  := subs(op(erzp1,1),az_1=unb1);
   //Pol. in unb1 mit Nullstelle az_1
   erzp1  := poly(ausdr,[unb1],base_field);  

   /* Koerpererweiterung, die durch primitives Element erzeugt wird, 
     generieren */
   ausdr  := subs(op(sgR[3],1),az_2=az_3);
   sgR[3] := poly(ausdr,[az_3],base_field);
   K3     := Dom::AlgebraicExtension(base_field,sgR[3],az_3);

   erzp1  := subsop(erzp1,3=K3);  //jetzt Polynom ueber K3 
   ausdr  := subs(op(sgR[2],1),az_2=az_3);
   ausdr  := subs(ausdr,az_1=unb1);
   sgR[2] := poly(ausdr,[unb1],K3);
   ggt    := gcd(sgR[2],erzp1);   // ggt = X-az_1 
   
   // Darstellung von az_1 und az_2 in K3 
   az_1   := K3(-1)*K3(tcoeff(ggt));
   az_2   := K3(az_3)-K3(sgR[1])*K3(az_1);
   return([K3,az_3,az_1,az_2]);

end_proc:
