/* --------------------------------------------------------------- 

   shiftequiv -- determines whether there exists an integer n
                 such that f(x-n)=g(x)

Call:    polylib::rootbound(f, g);

Parameter:  f, g -- univariate polynomials (DOM_POLY).  
                    Their coefficients must be integers or rationals. 

Return-Value: n or FAIL
--------------------------------------------------------------- */

polylib::shiftequiv := proc(f, g)
local n, c, X;
begin
  userinfo(9,"polylib::shiftequiv called.");
  // for convenience, allow expression-input
  if domtype(f) <> DOM_POLY then
    f := poly(f);
  end_if;
  if domtype(g) <> DOM_POLY then
    g := poly(g);
  end_if;
  // use Expr as field
  if op(f,3) <> Expr then f := poly(f, Expr) end_if;
  if op(g,3) <> Expr then g := poly(g, Expr) end_if;
  // no multivariate polynomials allowed
  if nops(op(f,2)) <> 1 or nops(op(g,2)) <> 1 then
    error("Can handle only univariate polynomials.");
  end_if;
  // not equivalent if the degrees differ
  if degree(f) <> degree(g) then 
    return(FAIL) 
  end_if;
  // not equivalent if the lcoeffs differ
  if lcoeff(f) <> lcoeff(g) then 
    return(FAIL) 
  end_if;
  // allow differently named indets
  X := op(f,2);
  if (op(g,2) <> X) then 
    g := poly(poly2list(g), X) 
  end_if; 
  // check for a candidate (Vieta?)
  n := degree(f);
  c := (coeff(f, n-1) - coeff(g, n-1)) / n / lcoeff(f);
  if domtype(c) <> DOM_INT then
    return(FAIL);
  end_if;
  // look whether they are equivalent
  return (_if(iszero(poly(f(op(X)-c))-g), -c, FAIL));
end_proc;
