//    


/*
    polylib::sortMonomials(f, ord)

    returns a list of monomials sorted in *descending* order w.r.t.
    the monomial order ord.

    ord may be the identifier LexOrder, DegreeOrder, DegInvLexOrder;
    or an object of type Dom::MonomOrdering

*/


polylib::sortMonomials:=
proc(f, ord=hold(LexOrder))
  local monomlist: DOM_LIST;
begin
  if args(0)=0 then
    error("sortMonomials called without arguments")
  end_if;
  if args(0)>4 then
    error("Wrong number of arguments")
  end_if;

  if f::dom::sortMonomials <> FAIL then
    return(f::dom::sortMonomials(args()))
  end_if;

  if testargs() then
    if testtype(f,Type::Union(Type::Arithmetical, DOM_POLY)) <> TRUE then
      error("Polynomial or arithmetical expression expected")
    end_if;
  end_if;

  
  if type(ord)=DOM_LIST then
    if testtype(f, Type::Arithmetical) then
      return(expr(polylib::sortMonomials(poly(f,ord), args(3..args(0)))))
    else
      return(polylib::sortMonomials(poly(f, ord), args(3..args(0))))
    end_if
  end_if;

  if type(ord) = DOM_IDENT then 
    if not contains({LexOrder, DegreeOrder, DegInvLexOrder}, ord) then
        error("Unknown monomial ordering")
    end_if;
  elif type(ord) = "function" then
    ord:=Dom::MonomOrdering(ord)
  elif type(ord) <> Dom::MonomOrdering then
    monomlist:= monomials(f);
    return(sort(monomlist, (x,y) -> bool(ord(degreevec(x), degreevec(y))>0)))
  end_if;

  monomials(f, ord)

end_proc:
      
