//    

// Astrid Wiemeyer, 1997 


/*

  polylib::splitfield(p)


  p - polynomial


  returns a list of

  - the splitting field of p

  - the roots of p, written as polynomial expressions in the primitive
    element of the splitting field


*/


polylib::splitfield :=
proc(p)
local  list, h_list, irr_factors, i, j, roots, roots_h, newpoly, split_result, 
       alg_ext, alg_ext_h, unb, ausdr,prim_result, hilf, merk, Q_ext,
       base_field;

begin  
     if testargs() then
       if args(0) <> 1 then
         error("one argument expected!");
       end_if;
       if domtype(p) = DOM_EXPR then
         p := poly(p);
       elif domtype(p) <> DOM_POLY then
         error("polynomial or polynomial expression expected!");
       end_if;   
     end_if;

     if op(p,3) = Expr then  p:=subsop(p,3=Dom::Rational); end_if;

     base_field      := op(p,3);
     p               := multcoeffs(p,1/lcoeff(p));
     list            := factor(p);
     list            := Factored::convert_to(list,DOM_LIST);
     irr_factors     := [multcoeffs(list[2*i],1/lcoeff(list[2*i]))
                        $ i=1..(nops(list)-1)/2];
     userinfo(10, "Number of irreducible factors: ".expr2text(nops(irr_factors)));

     split_result    := map(irr_factors,polylib::splitFieldIrreducible);

     /* Vielfachheit der irreduziblen Faktoren und Grad des Ausgangs -
       polynoms merken*/

     (split_result[i] := split_result[i].[list[2*i+1]].
                 [degree(irr_factors[i])]) $ i=1..nops(irr_factors);
     hilf             := u -> bool(u[1]<> base_field);

     /* Sortiere die Erweiterungen, die durch lineare Faktoren entstehen,
       die also wieder zu E fuehren aus */

     merk            := split(split_result,hilf);
     split_result    := merk[1];
     Q_ext           := merk[2];

     /* In diesem Fall gab es nur lineare Faktoren, d.h. die 
       Koerpererweiterung ist E selbst */

     if split_result = [] then
        return([base_field,[(Q_ext[i][2][1],Q_ext[i][3]) 
                $ i=1..nops(Q_ext)]]);
     end_if;

     alg_ext         := split_result[1][1];
     roots           := split_result[1][2];
    
     for i from 2 to nops(split_result) do
        roots_h      := split_result[i][2];
        unb          := genident();
        newpoly      := (split_result[i][1])::minpoly;
        ausdr        := subs(op(newpoly,1),
                        (split_result[i][1])::variable=unb);
        newpoly      := poly(ausdr,[unb],alg_ext);
        list         := factor(newpoly);
        list         := Factored::convert_to(list,DOM_LIST);
        alg_ext_h    := Dom::AlgebraicExtension(alg_ext,list[2]);
        prim_result  := polylib::primitiveElement(alg_ext,alg_ext_h);
        alg_ext      := prim_result[1];

        /* Anpassung der Nullstellen an die jetzt ermittelte 
          Koerpererweiterung */

        roots   := map(roots,polylib::horner,alg_ext::expr(prim_result[3]),
                      alg_ext::minpoly);
        roots_h := map(roots_h,polylib::horner,alg_ext::expr(prim_result[4]),
                      alg_ext::minpoly);
        roots   := roots.roots_h;
     end_for;
  
     roots_h :=[];
     h_list  :=[];

     // Erstelle eine Liste der Exponenten der Nullstellen 
     (h_list := h_list.[split_result[i][3] $ j=1..split_result[i][4]])
                                            $ i=1..nops(split_result);
     (h_list := h_list.[Q_ext[i][3] $ j=1..Q_ext[i][4]])
                                            $ i=1..nops(Q_ext);

     // Fuege an die Nullstellen ihre Exponenten an 
     (roots  := roots.Q_ext[i][2]) $ i=1..nops(Q_ext);
     roots_h :=[];
     (roots_h:=roots_h.[roots[i],h_list[i]]) $ i=1..nops(roots);

     return([alg_ext,roots_h]);
end_proc:



