/**
   Extract the variables of a polynomial or polynomial domain 
   in a uniform way for DOM_POLY and others
**/

polylib::variables :=
proc(p //: Type::Union(Type::Polynomial, Type::PolynomialDomain)
    ) : DOM_LIST
begin
    case domtype(p) 
      of DOM_POLY do return(op(p,2));
      of DOM_DOMAIN do
	if p::variables <> FAIL then
	    return(p::variables);
	else
	    return(p::indets); // for polylib::Poly
	end_if;
      otherwise
	  if p::dom::hasProp(Dom::Polynomial) then
	      // Special case for Dom::DistributedPolynomial([])
	      // TODO: fix the implementation of the method variables there
	      return([op(p::dom::indets(p))]);
	  else
	      return(p::dom::variables);
	  end_if;
    end_case;
end_proc:
