/*
 Pref::abbreviateOutput -- automatically replace common subexpressions by
                   abbreviations during output (Typesetting only)
*/

proc()
  option escape;
  local statusDefault, occurrences, occurrencesDefault,
        placeholder, placeholderDefault, 
        threshold, thresholdDefault, minLength, minLengthDefault;
begin
  statusDefault := _pref(hold(AbbreviateOutput)); // get kernel default
  occurrencesDefault := 2;
  placeholderDefault := `&sigma;_`;
  thresholdDefault := 75;
  minLengthDefault := 6;

  occurrences := occurrencesDefault;
  placeholder := placeholderDefault;
  threshold := thresholdDefault;
  minLength := minLengthDefault;

  Pref::abbreviateOutput := funcenv(
    proc(n)
      local r;
    begin
      case args(0) 
        of 0 do
          return(_pref(hold(AbbreviateOutput)))
        of 1 do
          if args(1) = NIL then // set default value or read Occurrences
            r := _pref(hold(AbbreviateOutput));
            // these are the defaults!!!
            _pref(hold(AbbreviateOutput) = statusDefault);
            occurrences := occurrencesDefault;
            placeholder := placeholderDefault;
            threshold := thresholdDefault;
            minLength := minLengthDefault;
            return(r);
          elif n = hold(Occurrences) then
            // read access
            return(occurrences);
          elif n = hold(Placeholder) then
            // read access
            return(placeholder);
          elif n = hold(Threshold) then
            // read access
            return(threshold);
          elif n = hold(MinLength) then
            // read access
            return(minLength);
          elif testtype(n, "_equal") and lhs(n) = hold(Occurrences) then
            r := occurrences;
            if testtype(rhs(n), Type::PosInt) then
              occurrences := rhs(n);
            else
              error("positive integer expected for number of occurrences")
            end; 
            return(r);
          elif testtype(n, "_equal") and lhs(n) = hold(Placeholder) then
            r := placeholder;
            if testtype(rhs(n), DOM_IDENT) then
              placeholder := rhs(n);
            else
              error("identifier expected for default placeholder")
            end; 
            return(r);
          elif testtype(n, "_equal") and lhs(n) = hold(Threshold) then
            r := threshold;
            if testtype(rhs(n), Type::PosInt) then
              threshold := rhs(n);
            else
               error("positive integer expected for abbreviation threshold")
            end; 
            return(r);
          elif testtype(n, "_equal") and lhs(n) = hold(MinLength) then
            r := minLength;
            if testtype(rhs(n), Type::PosInt) then
              minLength := rhs(n);
            else
              error("positive integer expected for minimal length of abbreviations")
            end; 
            return(r);
          elif domtype(n) <> DOM_BOOL or n = UNKNOWN then
            error("expecting TRUE or FALSE");
          else
            r := _pref(hold(AbbreviateOutput));
            _pref(hold(AbbreviateOutput) = n);
            return(r);
          end_if
        otherwise
          error("wrong number of arguments (expecting TRUE or FALSE)")
        end_case
    end_proc);
  Pref::abbreviateOutput::info := "Automatically replace common subexpressions by abbreviations in typesetting output";
end_proc():

// end of file 
