/*
   MuPAD needs to delete some files at the end of a session.
   This is done transparently for the user via _pref(CallOnExit).
   Pref::callOnExit fakes a view for the user without this internal
   OnExit Function.
*/

Pref::callOnExit:=
funcenv(
        proc(v)
          local getKernelVal, setKernelVal, RMfunc;
        begin
          getKernelVal :=
          proc()
            local res;
          begin
            res := _pref(hold(CallOnExit));
            RMfunc := res[1];
            res := [op(res, 2..nops(res))];
            case nops(res)
              of 0 do
                return(NIL);
              of 1 do
                return(op(res));
              otherwise
                return(res)
            end_case;
          end_proc;
            
          setKernelVal :=
          proc(val)
            local oldVal, newVal;
          begin
            oldVal := getKernelVal();
            case domtype(val)
              of DOM_NIL do
                newVal := Pref::callOnExit::default;
                break;
              of DOM_LIST do
                newVal := [RMfunc].val;
                break;
              otherwise
                newVal := [RMfunc, val]
            end_case;
            _pref(hold(CallOnExit)=newVal);
            oldVal;
          end_proc;
            
          case args(0)
            of 0 do
              return(getKernelVal())
            of 1 do
              return(setKernelVal(v));
            otherwise
              error("wrong no of args (expecting one argument)")
          end_case
        end_proc):

Pref::callOnExit::info := "This function is called, without any arguments, ".
                         "directly before MuPAD terminates.":

Pref::callOnExit::default := _pref(hold(CallOnExit)):

// end of file 
