Pref::maxMem:= funcenv(
    proc(n)
      local kbytes, convret;
    begin
        convret := 
        proc(kb)
          local mb;
        begin
          mb := unit::convert(kb*unit::kByte, unit::MByte);
          if nops(mb) = 2 and domtype(op(mb, 2)) = DOM_RAT then
            mb := subsop(mb, 2 = round(op(mb, 2), 2));
          end_if;
          mb;
        end_proc:
        case args(0) 
        of 0 do
            return(convret(_pref(hold(Maxmem))));
        of 1 do
            if args(1) = NIL then // set default value 
               n:= _pref(hold(Maxmem));
               _pref(hold(Maxmem) = 0);
               return(convret(n));
            end_if;
            kbytes := n;
            if domtype(n) <> DOM_INT then
              kbytes := unit::simplify(n/unit::kByte);
              if domtype(kbytes) = DOM_INT then
                n := kbytes;
              elif domtype((kbytes := float(kbytes))) = DOM_FLOAT then
                n := round(kbytes);
              end_if;
            end_if;
            if domtype(n) <> DOM_INT or n < 0 then
                error("expecting integer >= 0")
            else
                kbytes := _pref(hold(Maxmem));
                _pref(hold(Maxmem) = n); 
               return(convret(kbytes));
            end_if
        otherwise
            error("wrong number of arguments (expecting one integer >= 0)")
        end_case
    end_proc):
Pref::maxMem::info :=
  "Stops current calculation if MuPAD allocates more than Pref::maxMem kbytes.":

Pref::maxMem::default := 0:

// end of file 
