Pref::maxTime:= funcenv(
    proc(n)
      local sec;
    begin
        case args(0) 
        of 0 do
            return(_pref(hold(Maxtime))*unit::sec)
        of 1 do
            if args(1) = NIL then // set default value 
               n:= _pref(hold(Maxtime));
               _pref(hold(Maxtime) = 0);
               return(n*unit::sec);
            end_if;
            if domtype(n) <> DOM_INT then
              sec := float(unit::simplify(n/unit::sec));
              if domtype(sec) = DOM_FLOAT then
                n := ceil(sec);
              end_if;
            end_if;
            if domtype(n) <> DOM_INT or n < 0 then
                error("expecting integer >= 0")
            else
              sec := _pref(hold(Maxtime));
              _pref(hold(Maxtime) = n); 
              return(sec * unit::sec);
            end_if
        otherwise
            error("wrong number of arguments (expecting one integer >= 0)")
        end_case
    end_proc):
Pref::maxTime:= slot(Pref::maxTime,
"info","Stops current calculation if it runs longer than Pref::maxTime seconds."):

Pref::maxTime::default:= 0:

// end of file 
