Pref::outputDigits:=
  funcenv(
           proc(s)
             local oldval;
           begin
             oldval := _pref(hold(OutputDigits));
             case args(0)
               of 0 do /* nothing */ break;
               of 1 do
                 if s = NIL then // set default value 
                   s := Pref::outputDigits::default;
                 end_if;
                 case s
                   of UseDigits do s := 0; break;
                   of InternalPrecision do s := -1; break;
                 end_case;
                 oldval := _pref(hold(OutputDigits));
                 if s::dom <> DOM_INT or
                   _pref(hold(OutputDigits) = s) = FAIL then
                     error("bad argument (expecting pos. integer, UseDigits, or InternalPrecision)");
                 end_if;
                 break;
             otherwise
               error("wrong number of arguments (expecting pos. integer, UseDigits, or InternalPrecision)")
             end_case;
             case oldval
               of 0 do oldval := UseDigits; break;
               of -1 do oldval := InternalPrecision; break;
             end_case;
             oldval;
           end_proc):

Pref::outputDigits::info := "Controls the output of objects of type DOM_FLOAT.":

Pref::outputDigits::default := UseDigits:

null():

