/* VerboseRead -- preference to print information about
                 loading packages and files

  VerboseRead = 0:  no information (default)
  VerboseRead = 1:  information about loading packages
  VerboseRead = 2:  information about loading packages and files
*/


Pref::verboseRead:= funcenv(
    proc(n)
    begin
        case args(0) 
        of 0 do
            return( Pref::_verboseRead )
        of 1 do
            if args(1) = NIL then // set default value 
                n:= Pref::_verboseRead; sysassign(Pref::_verboseRead, 0);
                return( n )
            elif domtype(n) <> DOM_INT or n < 0 or n > 3 then
                error("expecting integer in range 0..2")
            else
                Pref::_verboseRead; sysassign( Pref::_verboseRead,n );
                return( %2 )
            end_if
        otherwise
            error("wrong number of arguments (expecting one integer in range 0..2)")
        end_case
    end_proc):

Pref::verboseRead::info := "Print a message if a library package or file is read.":
Pref::_verboseRead:= 0:
Pref::verboseRead::default := 0:

// end of file 