
prog::RINT:= table():

// Initialisieren aller Funktionen /////////////////////////////////////////////
prog::init:=
  proc(FUN = null(), OPT = null())
    local EN;
  begin
    if FUN = hold(All) then
      if OPT = hold(All) then prog::initall() end_if;
      // and again
      return(prog::initall())
    end_if;

    //
    if contains(prog::RINT, FUN) then
      if prog::RINT[FUN] = 0 then
        userinfo(Text, 11..11, "NOT else init entry ".prog::getname(FUN));
        return()
      else
        sysassign(prog::RINT[FUN], prog::RINT[FUN] - 1)
      end_if
    else
      sysassign(prog::RINT[FUN], 1)
    end_if;

    if domtype(FUN) = stdlib::LoadProc then
      FUN:= eval(FUN)
    end_if;

    case domtype(FUN)
      of DOM_FUNC_ENV do
        prog::init(op(FUN, 1));
        prog::init(op(FUN, 2));
        if domtype(op(FUN, 3)) = DOM_TABLE then
          for EN in map({op(op(FUN, 3))}, X->op(X, 1)) do
            userinfo(Text, 11..11, "init entry ".prog::getname(FUN)."::".EN);
            prog::init(slot(FUN, EN))
          end_for;
        end_if;
        break;
        
      of DOM_EXPR do
      of DOM_DOMAIN do
        if type(FUN) <> "_exprseq" and
           not contains({AxiomConstructor, CategoryConstructor, DomainConstructor}, FUN) then
          // stdlib::PROTECTED bzw stdlib::SYSPROTECTED enthalten auch module
          for EN in {op(prog::Entries(FUN))} minus {"PROTECTED", "SYSPROTECTED"} do
            userinfo(Text, 11..11, "init entry ".prog::getname(FUN)."::".EN);
            prog::init(slot(FUN, EN))
          end_for;
        end_if;
        break;
        
      of DOM_SET do
      of DOM_LIST do
      of DOM_TABLE do
        map(FUN, prog::init, OPT);
        break
      otherwise
        userinfo(Text, 11, "init ".prog::getname(FUN)." of type ".expr2text(domtype((FUN))));
    end_case;
    null()
  end_proc:

prog::initall:=
  proc()
    local GF, DF, list;
  begin
    // DOM_PROC /////////////////////////////////////////////////////////////
    userinfo(Text, 1, "pre-init all DOM_PROC");
    list := [op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_PROC)))];
    list := sort(list, (X, Y)->(expr2text(X)<expr2text(Y)));
    map(list, prog::init@eval);
    // DOM_FUNC_ENV /////////////////////////////////////////////////////////
    userinfo(Text, 1, "pre-init all DOM_FUNC_ENV");
    list := [op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_FUNC_ENV)))];
    list := sort(list, (X, Y)->(expr2text(X)<expr2text(Y)));
    map(list, prog::init@eval);

    // DOM_DOMAIN ///////////////////////////////////////////////////////////
    userinfo(Text, 1, "pre-init most DOM_DOMAIN");
    list := [op(select(stdlib::anames(3), (X)->(type(eval(X)) = DOM_DOMAIN)))];
    GF:= sort(list, (X, Y)->(expr2text(X)<expr2text(Y)));
    for DF in GF do
      DF:= eval(DF);
      if domtype(DF) = DOM_DOMAIN then
	//if contains(eval(DF), "constructor") then
	  prog::init(DF);
	  sysdelete(prog::init(DF))
	//end_if
      end_if
    end_for;
    null()
  end_proc:

prog::Entries:=
  proc(DOM)
    local AE;
  begin
    if domtype(DOM) = DOM_DOMAIN then
      if (AE:= ((eval(DOM))::allEntries())) <> FAIL then
        AE:= sort([op(AE minus (eval(DOM))::undefinedEntries())])
      else
        AE:= sort(map([op(eval(DOM))], X -> op(X, 1)));
      end_if;
      if  (eval(DOM))::allAutoEntries <> FAIL then
        AE := AE.[op((eval(DOM))::allAutoEntries)];
      end;
    elif domtype(DOM) = DOM_FUNC_ENV then
      if domtype((AE:= op(eval(DOM), 3))) = DOM_TABLE then
	if nops(AE) > 1 then
	  AE:= sort(map([op(AE)], X -> op(X, 1)))
	else
	  AE:= [op(AE, [1, 1])]
	end_if
      else
	AE:= []
      end_if
    else
      AE:= []
    end_if;
    AE
  end_proc:

prog::isGlobal:=
  proc(INDET)
  begin
    contains(level(stdlib::ENVIRONMENT_VARIABLES, 1) union stdlib::SYSTEM_CONSTANTS
	     union stdlib::LIBRARY_CONSTANTS union stdlib::OPTIONS
             union stdlib::PROTECTED
	     //union prog::getcheckglobals() // entfernt;
             , INDET)
    or // global variables of all current procedures
       _or(op(map(prog::PATH, X -> _if(contains(prog::globalIdents, X),
                                       contains(prog::globalIdents[X], INDET),
                                       FALSE))))
    or // protected identifiers
    bool(strmatch(expr2text(INDET), "#.*") = TRUE)
  end_proc:

