// prog::complexity - McCabe complexity of MuPAD procedures/expressions

// TODO: Local procedures!

prog::complexity :=
proc(l)
  local ret, doit;
begin
  ret := table();
  if l = All then
    prog::init(All);
    l := map(stdlib::anames(3), eval);
  end_if;
  if domtype(l) <> DOM_SET then
    l := {l};
  end_if;
  doit :=
  proc(ex, nam)
    local rek, sub;
  begin
    if args(0) < 2 then
      nam := prog::getname(ex);
    end_if;

    if contains(ret, nam) then
      return();
    end_if;
    ret[nam] := -1; // calculating right now, avoid infinite recursion
    rek :=
    proc(sub)
    begin
      if domtype(op(sub, 2)) in {DOM_FUNC_ENV, DOM_DOMAIN, DomainConstructor} then
        if not strmatch(prog::getname(op(sub, 2)), "^(remember::)?".nam) then
          next;
        end_if;
        doit(op(sub, 2), nam."::".op(sub, 1));
      else
        doit(op(sub, 2), nam."::".op(sub, 1));
      end_if;
    end_proc;
    
    case domtype(ex)
    of DOM_FUNC_ENV do
      ret[nam] := prog::complexity::expr(op(ex, 1));
      map([op(op(ex, 3))], rek);
      for sub in select(map({op(prog::rememberFuncsOrig)}, rhs),
        fn -> strmatch(prog::getname(fn), "^".nam."(::|$)")) do
        doit(sub, "remembered ".prog::getname(sub));
      end_for;
      break;
    of DOM_DOMAIN do
      map([op(ex)], rek);
      break;
    of DomainConstructor do
      ret[nam] := prog::complexity::expr(op(ex, 1));
    otherwise // DOM_PROC, DOM_EXPR, etc.
      ret[nam] := prog::complexity::expr(ex);
    end;
  end;
  map(l, doit);
  // do not return 0 entries
  select(ret, x -> not(op(x, 2) in {0, -1}));
end:


prog::complexity := funcenv(prog::complexity):

prog::complexity::expr :=
proc(ex)
begin
  if args(0) = 0 or ex = null() then
    return(0);
  end_if;
  ex := misc::maprec(ex,
    (ex -> bool(ex::dom = DOM_VAR)) = (x -> #DOM_VAR),
    Unsimplified);
  case domtype(ex)
  of DOM_PROC do
    return(prog::complexity::expr(op(ex, 4)) + 1);
  of DOM_ARRAY do
  of DOM_LIST do
  of DOM_SET do
  of piecewise do
    return(_plus(op(map([op(ex)], prog::complexity::expr))));
  of DOM_EXPR do
    case op(ex, 0)
    of hold(_while) do
      return(prog::complexity::cond(op(ex, 1)) +
        prog::complexity::expr(op(ex, 2)) + 1);
    of hold(_repeat) do
      return(prog::complexity::cond(op(ex, 2)) +
        prog::complexity::expr(op(ex, 1)) + 1);
    of hold(_if) do
      return(prog::complexity::cond(op(ex, 1)) +
        prog::complexity::expr(op(ex, 2)) + prog::complexity::expr(op(ex, 3)) + 1);
    of hold(_for) do
    of hold(_for_down) do
    of hold(_for_in) do
    of hold(_seqgen) do
    of hold(_seqin) do
    of hold(_seqstep) do
    of hold(_case) do
      // TODO: The complexity of a _case construct
      // actually depends heavily on the use of break statements --
      // using them somewhere else than at the end or not using
      // them at the end increases the complexity.
      return(_plus(op(map([op(ex)], prog::complexity::expr))) + 1);
    otherwise
      return(_plus(op(map([op(ex, 0), op(ex)], prog::complexity::expr))));
    end_case;
  end_case;
  0;
end:

prog::complexity::cond :=
proc(ex)
begin
  case op(ex, 0)
  of hold(_lazy_and) do
  of hold(_lazy_or) do
  of hold(_and) do
  of hold(_or) do
    return(_plus(op(map([op(ex)], prog::complexity::cond))) + nops(ex) - 1);
  of hold(_not) do
    return(prog::complexity::cond(op(ex)));
  otherwise
    return(prog::complexity::expr(ex));
  end;
  0;
end:
