// 

// find(ARG, SOBJ, < Type, NoProc>)
//   ARG    - any MuPAD object
//   SOBJ   - any MuPAD object or type identifier
//   Type   - SOBJ is taken as type identifier
//   NoProc - no sub procedure of ARG is explored
//
// find(ARG, SOBJ) returns all pathes (see op, subsop) to SOBJ
// inside of ARG as sequemnce or null(), if SOBJ cannot be found in ARG.
//
// With option Type SOBJ is taken as type identifier usable with type, domtype
// or testtype. All objects of type SOBJ are searched.
// 
// With NoProc all subprocedures of ARG are not explored further.
// 

// find operands
prog::find:=
  proc()
    save FIND, OPT, i, REMEMBER, TT, TYPE, OBJECTS, DEPTH, DEPTHMAX, TESTTYPE,
         EXPR, ARG, RESULT, SOBJ, NOPROC;
  begin
    if args(0) < 2 then
      error("wrong number of arguments");
    end_if;

    TYPE:=
      proc()
        save EXPR;
        name prog::find::TYPE;
      begin
        if args(0) = 0 then
          return(DOM_NULL);
        end_if;
        EXPR := args(1);
        if domtype(EXPR) = DOM_EXPR then
          if domtype(op(EXPR, 0)) = DOM_EXPR then
            TYPE(op(EXPR, 0))
          elif type(op(EXPR, 0)) = DOM_VAR then
            "DOM_VAR"
          else
            type(EXPR)
          end_if
        else
          type(EXPR)
        end_if;
      end_proc:

    REMEMBER := {};
    OBJECTS := {};

    FIND :=
      proc(/*ARGS, SOBJ, RESULT = []*/)
        name prog::find;
        save ARG, SOBJ, RESULT, P, i, DEPTH,
             NOPROC; // save NOPROC!
      begin
        [ARG, SOBJ, RESULT] := [args(1), args(2), args(3)];
        if contains(REMEMBER, ARG) then
          userinfo(10, "skip (remember) " . prog::getname(op(ARG)));
          return()
        elif contains({DOM_PROC, DOM_DOMAIN, DOM_FUNC_ENV}, domtype(op(ARG))) then
          userinfo(10, "remember " . prog::getname(op(ARG)));
          REMEMBER := REMEMBER union {ARG};
        end_if;
        ARG := op(ARG);
        SOBJ := op(SOBJ);
        if domtype(ARG) = DOM_IDENT or domtype(ARG) = DOM_EXPR and op(ARG, 0) = hold(slot) and not testtype(op(ARG, 1), DOM_VAR) then
          // evaluate idents and slots
          if traperror((i := eval(ARG))) <> 0 then
            i := ARG
          end_if
        else
          i := ARG
        end_if;
        
        if TESTTYPE then
          if traperror(TYPE(i) = SOBJ or domtype(i) = SOBJ or testtype(i, SOBJ)) <> 0 then
            // prevent errors while evaluation of undefined DOM_VARs
            // warning("error while evaluating ".prog::getname(ARG))
            warning("error while evaluating '".expr2text(args())."'")
          elif TYPE(i) = SOBJ or domtype(i) = SOBJ or testtype(i, SOBJ)
               or TYPE(ARG) = SOBJ or domtype(ARG) = SOBJ or testtype(ARG, SOBJ) then
            //if RESULT <> [] then
              OBJECTS := OBJECTS union {RESULT} // remember all such objects, but analyze further
              //return(RESULT)
            //end_if
          end_if
        elif ARG = SOBJ or i = SOBJ then
          return(RESULT)
        end_if;
        
    case expr2text(domtype(ARG))
          of "blockTransparent" do
          of "DOM_LIST" do
          of "DOM_INTERVAL" do
          of "DOM_RAT" do
          of "DOM_SET" do
          of "DOM_TABLE" do
          of "DOM_EXPR" do
          of "Content" do
            if op(ARG, 0) <> FAIL then
              RESULT:= [FIND([op(ARG, i)], [SOBJ], append(RESULT, i)) $ i = 0..nops(ARG)]
            else
              RESULT:= [FIND([op(ARG, i)], [SOBJ], append(RESULT, i)) $ i = 1..nops(ARG)]
            end_if;
            break
          of "DOM_DOMAIN" do
            if DEPTH < DEPTHMAX then // <> UNKNOWN then
              DEPTH := DEPTH + 1;
              RESULT:= [FIND([op(ARG, i)], [SOBJ], append(RESULT, i)) $ i = 1..nops(ARG)]
            else
              userinfo(2, "MAXDEPTH reached");
              //OBJECTS := OBJECTS union {RESULT};
              RESULT := []
            end_if;
            break
          of "DOM_PROC" do
            userinfo(10, "found procedure " . prog::getname(ARG));
            if DEPTH < DEPTHMAX
               and NOPROC <> TRUE then // <> UNKNOWN then
              userinfo(10, "noproc is not TRUE, inspect " . prog::getname(ARG));
              if NOPROC = UNKNOWN then
                userinfo(10, "set noproc to TRUE");
                NOPROC := TRUE
              end_if;
              DEPTH := DEPTH + 1;
              RESULT:= [FIND(/*misc::maprec*/([op(ARG, [4, i])]/*,
                                          {DOM_VAR} = (X -> hold(_DOMVAR)(op(X)))*/),
                             [SOBJ], append(RESULT, 4, i))
                             $ i = 0..nops(op(ARG, 4))]
            elif NOPROC = TRUE then
              userinfo(2, "skip subprocedure " . prog::getname(ARG));
              RESULT := []
            else
              userinfo(2, "MAXDEPTH reached");
              //OBJECTS := OBJECTS union {RESULT};
              RESULT := []
            end_if;
            break
          of "DOM_FUNC_ENV" do
            if DEPTH < DEPTHMAX then // <> UNKNOWN then
              DEPTH := DEPTH + 1;
              RESULT := [FIND([op(ARG, i)], [SOBJ], append(RESULT, i)) $ i = 1..3]
            else
              userinfo(2, "MAXDEPTH reached");
              //OBJECTS := OBJECTS union {RESULT};
              RESULT := []
            end_if;
            break
          of "DOM_COMPLEX" do
            // special: 'I'
          otherwise
            RESULT:= []
        end_case;
    
        op(RESULT)
      end_proc;

    OPT := prog::getOptions(3, [args()],
                            table(Type = FALSE,
                                  hold(Type) = FALSE,
                                  hold(NoProc) = FALSE,
                                  //hold(First) = FALSE,
                                  hold(Depth) = MAXLEVEL))[1];

    TESTTYPE := bool(OPT[hold(Type)] = TRUE or OPT[Type] = TRUE);
    NOPROC := bool(OPT[hold(NoProc)] = TRUE) and UNKNOWN;
    DEPTH := 0;
    DEPTHMAX := OPT[hold(Depth)];

    TT := FIND([(args(1))], [(args(2))], []);
    op(sort([TT, op(OBJECTS)]))
    
  end_proc:
