/*

   prog::findSlot :  find all domains and function environments
                     which define the given slot (overload the
                     corresponding function)

  Example:
 
  >> prog::findSlot("exp")  

      {DOM_INTERVAL, Dom::DenseMatrix(), Dom::Interval, 
       Dom::FloatIV, Dom::Matrix(), Dom::ImageSet,
       Dom::Multiset, combine, simplify}

  // frueher gabs auch piecewise ???

  >> prog::findSlot("exp")  
  {piecewise, Dom::ImageSet, Dom::Multiset, Dom::Interval,

     Dom::DenseMatrix(), simplify, combine}

  Warning:  This function is extremely slow and memory hungry.
            It loads the complete library via prog::init first.
            Do not use in programs!
*/

prog::findSlot := proc(slotStr : DOM_STRING)
  local getSlots, toConsider, res, doms;
begin 
  prog::init(All);

  getSlots :=
  proc(x)
    local entries;
  begin
    entries := {op(prog::Entries(x))};
    if domtype(x) = DOM_DOMAIN and
      contains(x, "interface") then
       entries := entries intersect map(x::interface, expr2text);
    end_if;
    contains(entries, slotStr)
  end_proc;
                    
  // we are only interested in domains and funcenvs
  toConsider := eval(anames(DOM_DOMAIN) union anames(DOM_FUNC_ENV))
                // but not all
                minus {AxiomConstructor, CategoryConstructor,
                       DomainConstructor, Ax, Cat, stdlib, specfunc}:
                    
  // all domains and funcenvs bound to variables
  res := select(toConsider, getSlots);

  // look in the domains package
  doms := map(Dom::interface minus {hold(BaseDomain)}, expr2text);
  doms := zip([Dom $ nops(doms)], [op(doms)], slot);
  res := res union
         {op(select(select(map(doms, eval), testtype, DOM_DOMAIN), getSlots))};
end:
