//   

/*
prog::makeTestFile(f, <Options>)

  manipulates the procedure or function environment 'f'
    every following call of 'f' produces a 'prog::test'
    call that is written into a specified file

prog::makeTestFile(f, Open = filename <, Append | Write>, <, Properties>)

  opens the file 'filename' (complete name must be given)
    and manipulates 'f'

prog::makeTestFile(f, Close)

  closes the opened file and rebuilds 'f' to the original
  procedure or function environment

*/

/* This table will contain the original code of all
   manipulated functions and is used for rebuilding */

prog::mktestTab := table():

prog::makeTestFile:=
proc(_f_)
  option hold, escape;
  local FILE, FILENAME, OPT, tabIndex, ff, p, allOptions, types,
        mktest_internal, mktest_proc, mktest_func_env, mktest_properties;
begin
  if args(0) = 0 then
    error("first argument must be a procedure or function environment")
  end_if;

  allOptions := table(Open = "",
                      Append = FALSE, Write = FALSE,
                      hold(Close) = FALSE,
                      Properties = FALSE);
  types := table(Open = DOM_STRING,
                 Append = DOM_BOOL, Write = DOM_BOOL,
                 hold(Close) = DOM_BOOL,
                 Properties = DOM_BOOL);

  mktest_internal :=    /* mktest for kernel functions */
  proc(p,n)
    option escape, noDebug;
  begin
    subsop(proc()
             local  lastResult, _x_1_, _arguments_;
             option noDebug;
           begin
             hold(id)(NIL, "produces tests");
             sysassign(slot(prog, "mktest_depth"),
                       slot(prog, "mktest_depth") + 1);
             _x_1_ := p;
             _arguments_ := args();
             if slot(prog, "mktest_depth") < 1 then
               fprint(NoNL, FILE, "prog::test([".n."(".expr2text(_arguments_).")], ");
             end_if;
             hold(_x_1_)(_arguments_);
             lastResult := eval(%);
             if slot(prog, "mktest_depth") < 1 then
               fprint(Unquoted, FILE, expr2text([lastResult])."):")
             end_if;
             sysassign(slot(prog, "mktest_depth"),
                       slot(prog, "mktest_depth") - 1);
             lastResult;
           end_proc,
           6 = _f_,
           [4, 1, 1] = n,
           [4, 2, 1, 2] = "mktest_depth_".FILENAME,
           [4, 2, 2, 1, 2] = "mktest_depth_".FILENAME,
           [4, 5, 1, 1, 2] = "mktest_depth_".FILENAME,
           [4, 8, 1, 1, 2] = "mktest_depth_".FILENAME,
           [4, 9, 1, 2] = "mktest_depth_".FILENAME,
           [4, 9, 2, 1, 2] = "mktest_depth_".FILENAME) // name
  end_proc;
	       
  mktest_proc :=      /* mktest for procedures */
  proc(p, n)
    name mktest_proc;
    local mktest_exit;
    option escape;
  begin

    mktest_exit :=    /* print result on exit ; also used for return */
      subsop(proc(n)
               option escape;
               name mktest_exit;
             begin
               proc()
               begin
                 if slot(prog, "mktest_depth") < 1 then
                   fprint(Unquoted, FILE,
                          expr2text([args()]), "):")
                 end_if;
                 sysassign(slot(prog, "mktest_depth"),
                           slot(prog, "mktest_depth") - 1);
                 args()
               end_proc
             end_proc,
             [4, 4, 1, 1, 1, 2] = "mktest_depth_".FILENAME,
             [4, 4, 2, 1, 2] = "mktest_depth_".FILENAME,
             [4, 4, 2, 2, 1, 2] = "mktest_depth_".FILENAME);

    /* create new Proc with mktest-token, enter-info, old code, exit-info */
    subsop(p, 4 =
           hold(_stmtseq)(
                          hold(id)(n, "produces tests"),
                          hold(sysassign(slot(prog, ""),
                                         slot(prog, "") + 1)),
                          hold(_if)(NIL,
                                    hold(fprint)(NoNL, FILE,
                                                 NIL,
                                                 prog::getname(_f_),
                                                 "(",
                                                  hold(expr2text(args())),
                                                 ")], "),
                                    NIL),
                          hold(_exprseq)(subs(op(p,4),hold(return)=return@mktest_exit(n),
                                              Unsimplified)),
                          mktest_exit(n),
                          hold(%(%2))),
           [4,3,1] = hold(_less)(hold(slot)(prog, "mktest_depth_".FILENAME), 1),
           [4,3,2,3] = "prog::test([",
           [4,2,1,2] = "mktest_depth_".FILENAME,
           [4,2,2,1,2] = "mktest_depth_".FILENAME,
	   Unsimplified)
  end_proc;

  // mktest function environment 'ENV'
  mktest_func_env:=
    proc(ENV, ENVID)
      local Pr1;
      name prog::mktest::mktest_func_env;
    begin
      // manipulate only the "main" procedure
      userinfo(1, "manipulate function environment '".prog::getname(ENV)."'");
      Pr1:= op(ENV, 1);
      case domtype(Pr1)
	of DOM_PROC do
	  Pr1:= mktest_proc(op(ENV, 1), expr2text(ENVID));
	  break;
	  
	of DOM_EXEC do
	  Pr1:= mktest_internal(op(ENV, 1), expr2text(ENVID));
	  break;
      end_case;
        
      subsop(ENV, 1 = Pr1)
    end_proc;

  // generates message to assume properties of identifiers for each test
  // and delete it after a test
  mktest_properties:=
    proc(INOUT = 1, INPUT)
    begin
      if OPT[Properties] then
        if INOUT = 1 then // before
        else // after
        end_if
      else
        op(["prog::test(", ""], INOUT)
      end_if
    end_proc;

  // -- BEGIN -------------------------

  // functions that cannot be manipulated
  if contains({hold(fprint), hold(hold), hold(DOM_SET::sort)}, _f_) then
    error("this function cannot be manipulated")
  elif contains({hold(_concat), hold(_procdef), 
                 hold(length), hold(Pref), hold(strmatch),
                 hold(anames), hold(type), hold(substring), hold(domtype),
                 hold(contains), hold(sysassign)}, _f_) then
    warning("this function should not be manipulated, unexpected sideeffects occurs")
  elif Pref::typeCheck() <> hold(None) and contains({hold(testtype)}, _f_) then
    error("this function cannot be manipulated, when 'Pref::typeCheck' is not 'None'")
  end_if;

  ff:=context(_f_);
  prog::init(ff);

  // extract options
  OPT:= prog::getOptions(2, [context(args())], allOptions, TRUE, types)[1]; // skip filename
  if OPT[Open] <> "" then
    FILENAME:= OPT[Open]
  else
    FILENAME:= prog::getname(_f_).".tst"
  end_if;

  if OPT[Open] <> "" or
     not OPT[hold(Close)] and not contains(prog::mktestTab, _f_) then
    // open file
    if OPT[Append] or OPT[Write] then
      if OPT[Append] then
        if (FILE:= fopen(FILENAME)) <> FAIL then
          fclose(FILE);
          if (FILE:= fopen(Text, FILENAME, Append)) = FAIL then
            error("cannot open '".FILENAME."' for append")
          else
            fprint(Unquoted, FILE, "") // newline
          end_if
        else
          error("cannot open '".FILENAME."' for append")
        end_if
      else // Write
        if (FILE:= fopen(FILENAME)) <> FAIL then
          fclose(FILE);
          warning("file '".FILENAME."' was overwritten.")
        end_if;
        if (FILE:= fopen(Text, FILENAME, Write)) = FAIL then
          error("cannot open '".FILENAME."' for write")
        end_if
      end_if
    else
      // don't overwrite existing file, don't append automatically
      FILE:= fopen(FILENAME);
      if FILE = FAIL then // error
        if (FILE:= fopen(Text, FILENAME, Write)) = FAIL then
          error("cannot open '".FILENAME."' for write")
        end_if
      else // append
        fclose(FILE);
        error("file '".FILENAME."' exists. Use option 'Append' or 'Write'.")
      end_if
    end_if;
      
    // file is open, prepare test
    fprint(Unquoted, FILE, "// generated test file for '".prog::getname(_f_)."'");
    fprint(Unquoted, FILE, ""); // newline
    fprint(Unquoted, FILE, "prog::testinit(\"".prog::getname(_f_)."\"):"); // 
    fprint(Unquoted, FILE, "prog::testfunc(".prog::getname(_f_)."):"); // 
    fprint(Unquoted, FILE, ""); // newline

    // remember FILE and FILENAME for closing
    sysassign(prog::mktestTab[_f_, "File"], FILE);
    sysassign(prog::mktestTab[_f_, "Name"], FILENAME);
      
    case domtype(ff)
      /*  ff is a internal function or procedure with slot's */
      of DOM_FUNC_ENV do
        userinfo(1, "manipulate function environment '".prog::getname(ff)."'");
        sysassign(prog::mktestTab[_f_], ff):
        stdlib::syseval(evalassign(_f_, mktest_func_env(ff, _f_), 1));
        break
      of DOM_PROC do
        userinfo(1, "manipulate procedure '".prog::getname(ff)."'");
        if type(_f_) = "slot"
           and domtype(context(op(_f_, 1))) = DOM_DOMAIN then
          sysassign(prog::mktestTab[_f_], ff);
          stdlib::syseval((evalassign(_f_,mktest_proc(ff, expr2text(_f_)), 1)))
        else
          sysassign(prog::mktestTab[_f_], ff):
          stdlib::syseval((evalassign(_f_,mktest_proc(ff, expr2text(_f_)), 1)))
        end_if;
        break
      otherwise
        error("first argument must be a procedure or function environment")
    end_case;

    // init depth counter
    // only first call is traced, no recursive calls
    sysassign(slot(prog, "mktest_depth_".FILENAME), -1);
    
    fprint(Unquoted, 0, "Info: function '".prog::getname(_f_)
                        ."' is manipulated, file '".FILENAME."' is opened.")
  else // close

    if contains(prog::mktestTab, _f_) then
      FILE:= prog::mktestTab[_f_, "File"];
      fprint(Unquoted, FILE, "");
      fprint(Unquoted, FILE, "prog::testexit():");
      fclose(FILE)
    else
      error("function was not manipulated")
    end_if;

    if type(_f_) = "slot" then
      if type(_f_) = "slot"
         and domtype(context(op(_f_, 1))) = DOM_DOMAIN then
        sysdelete(prog::mktestTab[op(_f_, 1)])
      end_if;
      tabIndex := hold(slot)(op(_f_,1),op(_f_,2));
      if not contains(prog::mktestTab, tabIndex) then
        error("function was not manipulated")
      end_if;
   
      stdlib::syseval(evalassign(_f_, prog::mktestTab[tabIndex], 2));
      sysdelete(prog::mktestTab[tabIndex]);
    else
      p:= eval(_f_);
      if not contains(prog::mktestTab, _f_) then
        error("function was not manipulated")
      end_if;
      stdlib::syseval(evalassign(_f_, prog::mktestTab[_f_], 2));
      sysdelete(prog::mktestTab[_f_]);
    end_if;

    // real filename
    FILENAME:= prog::mktestTab[_f_, "Name"];
    
    // delete depth counter
    sysdelete(slot(prog, "mktest_depth_".FILENAME));
    
    fprint(Unquoted, 0, "Info: function '".prog::getname(_f_)
                        ."' is restored, file '".FILENAME."' is closed.")

  end_if
end_proc:
