//   


/*
prog::nameofdomvar(v) 

This function returns the real name of a DOM_VAR as a character string. 
It can only be used within a procedure and can only refer to the local 
variables of this procedure or to that of its parents... .
*/

prog::nameofdomvar:=
proc(v)
  option hold, noDebug;
  local increase_context_level, s, i;
begin
   if testargs() then
      if args(0) <> 1 then
         error("Wrong number of arguments")
      end_if;
      if domtype(args(1)) <> DOM_VAR then
         error("DOM_VAR expected")
      end_if;
   end_if;

   // increase context level of all DOM_VAR's in condition by 1,
   // i.e., DOM_VAR(0,2) -> DOM_VAR(1,2), DOM_VAR(1,2) -> DOM_VAR(2,2) etc.
   // this is necessary for some mysterious reason
   increase_context_level := proc(e) 
   begin
      if domtype(e) = DOM_VAR then
        subsop(e, 1 = op(e, 1) + 1, Unsimplified)
      elif nops(e) = 0 then
        e
      elif nops(e) = 1 and e = op(e) then
        e
      elif domtype(e) = DOM_EXPR then
        subsop(e, i = increase_context_level(op(e, i)) $ i = 0..nops(e), Unsimplified)          
      else
        subsop(e, i = increase_context_level(op(e, i)) $ i = 1..nops(e), Unsimplified)
      end_if;
   end_proc:
   s:= increase_context_level(args());

   // strange, but it works ...
   s:= context(hold(expr2text)(hold(hold)(s)));
end_proc:
