//   

// prog::ntime
//   ()          - returns a factor to normalize timings
//                 evaluation time must be divided by this factor
// 
//   (statement) - returns evaluation time of 'statement' normalized
//                 
//

prog::ntime:=
  proc(TIME)
    local FACTOR, k, T, ntimeTestProc, x, i, debugFactor, archFactor;
    option hold, remember;
    save DIGITS;
  begin
    // dummy proc as time measure for procedure calls
    ntimeTestProc:= proc(x)
                      local y;
                    begin
                      y:= x;
                      if x > y then
                        return(x)
                      else
                        return(y)
                      end_if
                    end_proc;

    // reset to default value
    delete DIGITS;
    
    if (traperror(stdlib::tcov(hold(Debug))) = 0) then 
      debugFactor := 2.5;
    elif stringlib::contains(strprint(hold(Debug),1), "sig") then
      debugFactor := 1.75;
    else
      debugFactor := 1.0;
    end_if;
    
    archFactor := 1.0;
    if sysname(Arch) = "win32" then
      archFactor := 0.4;
    elif sysname(Arch) = "win64" then
      archFactor := 0.85;
    elif sysname(Arch) = "glnxa64" then
      archFactor := 1.35;
    elif sysname(Arch) = "maci64" then
      archFactor := 1.35;
    end_if;
    
    
    // return normalize factor
    if args(0) = 0 then
      // calibrate processor time
      T:= time();
      FACTOR:= 0;
      while time() - T < 200 do // 200 milli seconds
        FACTOR:= FACTOR + 1;
      end_while;
      
      // perform several MuPAD operations
      T:= time((T:= [];
                for k from 0 to FACTOR/7 do
                  // sometimes procedure call and memory-allocation operations
                  if specfunc::trunc(k/20) mod 20 = 0 then
                    T:= append(T, ntimeTestProc(i) $ i = 1..50)
                  else
                    x:= 42;
                    (x := x^2+x+1) $ i = 1..12;
                    x:= 1.235;
                    (x := x*(x + 1)) $ i = 1..20;
                  end_if
                end_for));

      return(T/(FACTOR/13.0)*debugFactor*archFactor)
    else
      FACTOR:= prog::ntime();
      T:= time((k := context(TIME)));
      if T <= 10 and domtype(k) = DOM_INT then
        specfunc::trunc(k/FACTOR)
      elif T <= 10 and domtype(k) = DOM_FLOAT then
        k/FACTOR
      else
        specfunc::trunc(T/FACTOR)
      end_if
    end_if
  end_proc:
