// prog::remember(FUNC, <DEP, <DEF, >> <, OPTION>)
//   returns a procedure, that calls FUNC and keeps results for later using
//
// FUNC      - any MuPAD procedure or function environment
// DEP       - procedure, that is called with the input to FUNC and
//             must return a info to determine, whether two inputs are
//             equal or not, e.g., get out all properties of involved identifiers
// DEF       - procedure (or constant value), that is called with the
//             input, when a recursion is detected, and that returns the
//             value to return
// OPTION    - PreventRecursion, Trace, All
//
//   PreventRecursion - verhindert endlos-Rekursionen
//   Debug            - Option noDebug wird nicht gesetzt
//   All              - merkt sich alle Paare input, depends(input)
//

//!!!! insert names of arguments and default values

prog::rememberFuncs := {}:
prog::rememberFuncsOrig := table():
prog::clearRememberFuncs := () -> map(prog::rememberFuncs, x -> x(Remember, Clear)):
prog::showRememberFuncs := () -> table(map(prog::rememberFuncs, x-> prog::getname(x)=x(Remember, Print))):

alias(maxRemember = 152);

prog::remember:=
  proc(FKT, DEP = FAIL, PRE = null(), DEF = null())
    option escape, noDebug;
    local rememberTable, rememberTableOld, rememberTableConstant, FN;
  begin
    // to ease code authoring and debugging,
    // the dependency functions for procedures
    // with option noDebug get this option, too:
    if domtype(DEP) = DOM_PROC and
      ((domtype(FKT) = DOM_PROC and contains({op(FKT, 3)}, hold(noDebug))) or
       (domtype(FKT) = DOM_FUNC_ENV and
        contains({op(FKT, [1,3])}, hold(noDebug)))) then
      DEP := subsop(DEP, 3=(op(DEP, 3), hold(noDebug)), 4 = op(DEP, 4));
    end_if;
    if contains({DOM_PROC, DOM_FUNC_ENV}, domtype(FKT)) then
      sysassign(prog::rememberFuncsOrig[prog::getname(FKT)], FKT);
      if domtype(FKT) = DOM_FUNC_ENV then
        subsop(FKT, 1 = prog::remember(op(FKT, 1), DEP, args(args(0))))
      else
        rememberTable:= table();
        rememberTableConstant := rememberTableOld:= table();
        FN:= prog::getname(FKT);

        //if args(args(0)) = hold(All) then
        //  subsop(proc()
        //           local IND;
        //           option noDebug;
        //         begin
        //           IND:= [[args()], [DEP(args())]];
        //           if contains(rememberTable, IND) then
        //             userinfo(10, "Result found in remember table...[".FN."]");
        //             return(rememberTable[IND])
        //           end_if;
        //           rememberTable[IND]:= FKT(args())
        //         end_proc,
        //         6 = text2expr("remember::".FN),
        //         1 = op(FKT, 1))
        // wie option remember
        if args(0) = 1 then
          subsop(proc()
                   local RET;
                   option noDebug;
                 begin
                   if args(0) > 0 and args(1) = hold(Remember) then
                     //userinfo(10, "Only remember actions ... [".FN."]");
                     if args(2) = hold(ClearPrevent) then
                      //
                     elif args(2) = hold(Clear) then
                       rememberTable:= table();
                       rememberTableOld:= table();
                       rememberTableConstant := table();
                     elif args(2) = hold(Print) then
                       return(table(rememberTable,rememberTableOld))
                     end_if;
                     return()
                   end_if;
                   if contains(rememberTable, [args()]) then
                     userinfo(10, "result found in rmember table... [".FN."]");
                     RET:= rememberTable[[args()]];
                     return(op(RET))
                   end_if;
                   if contains(rememberTableOld, [args()]) then
                     userinfo(10, "Result found in remember table... [".FN."]");
                     RET:= rememberTableOld[[args()]];
                     return(op(RET))
                   end_if;
                   RET:= FKT(args());
                   if nops(rememberTable)>maxRemember then
                    rememberTableOld := rememberTable;
                    rememberTable := table();
                   end_if;
                   rememberTable[[args()]]:= [RET];
                   RET
                 end_proc,
                 6 = text2expr("remember::".FN),
                 1 = op(FKT, 1))
        // keine Endlosrekursion
        elif DEP = hold(PreventRecursion) then
          if args(args(0)) <> hold(PreventRecursion) then
            DEF := args(args(0))
          else
            DEF := id
          end_if;
          subsop(proc()
                 option noDebug;
                 save ` saved values for prog::remember-functions `;
                 begin
                   if args(0) > 0 and args(1) = hold(Remember) then
                     //userinfo(10, "Only remember actions ... [".FN."]");
                     if args(2) = hold(ClearPrevent) then
//                       ` saved values for prog::remember-functions ` := table();
                     elif args(2) = hold(Clear) then
                     elif args(2) = hold(Print) then
                      return(table());
                     end_if;
                     return()
                   end_if;
                   if contains(` saved values for prog::remember-functions `, [FN,args()]) then
                      userinfo(10, "Recursion detected ... [".FN."]");
                      return(DEF(args()));
                   end_if;
                   sysassign(` saved values for prog::remember-functions `[[FN,args()]], TRUE);
                   FKT(args());
                 end_proc,
                 6 = text2expr("remember::".FN),
                 1 = op(FKT, 1))
        elif PRE = hold(PreventRecursion) then // DEP, Prevent
          if args(args(0)) <> hold(PreventRecursion) then
            DEF := args(args(0))
          else
            DEF := id
          end_if;
          if DEP = FAIL then // Prevent mit remember, ohne DEP
            subsop(proc()
                     local RET;
                     save ` saved values for prog::remember-functions `;
                     option noDebug;
                   begin
                     if args(0) > 0 and args(1) = hold(Remember) then
                       //userinfo(10, "Only remember actions ... [".FN."]");
                       if args(2) = hold(ClearPrevent) then
//                           ` saved values for prog::remember-functions ` := table();
                       elif args(2) = hold(Clear) then
                         rememberTable:= table();
                         rememberTableOld:= table();
                         rememberTableConstant := table();
                       elif args(2) = hold(Print) then
                         return(table(rememberTable,rememberTableOld))
                       end_if;
                       return()
                     end_if;
                     if contains(` saved values for prog::remember-functions `,[FN,args()]) then
                        userinfo(10, "Recursion detected ... [".FN."]");
                        //delete rememberTable[[args()]];
                        return(DEF(args()));
                     end_if;
                     if contains(rememberTable, [args()]) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(rememberTable[[args()]], 1));
                     end_if;
                     if contains(rememberTableOld, [args()]) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(rememberTableOld[[args()]], 1));
                     end_if;
                     sysassign(` saved values for prog::remember-functions `[[FN,args()]], TRUE);
                     RET:= FKT(args());
                     if nops(rememberTable)>maxRemember then
                       rememberTableOld := rememberTable;
                       rememberTable := table();
                     end_if;
                     rememberTable[[args()]]:= [RET];
                     RET
                   end_proc,
                   6 = text2expr("remember::".FN),
                   1 = op(FKT, 1))
        else // Prevent mit remember, mit DEP
          subsop(proc()
                   local RET, depval;
                   option noDebug;
                    save ` saved values for prog::remember-functions `;
                 begin
                   if args(0) > 0 and args(1) = hold(Remember) then
                     //userinfo(10, "Only remember actions ... [".FN."]");
                     if args(2) = hold(ClearPrevent) then
//                       ` saved values for prog::remember-functions ` := table();
                     elif args(2) = hold(Clear) then
                       rememberTable:= table();
                       rememberTableOld:= table();
                       rememberTableConstant := table();
                     elif args(2) = hold(Print) then
                       return(table(rememberTable,rememberTableOld))
                     end_if;
                     return()
                   end_if;
                  if contains(` saved values for prog::remember-functions `,[FN,args()]) then
                    userinfo(10, "Recursion detected ... [".FN."]");
                    //delete rememberTable[[args()]];
                    return(DEF(args()))
                  end_if;
                   if contains(rememberTableConstant, [args()]) then
                     RET:= rememberTableConstant[[args()]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                  depval := DEP(args());
                   if contains(rememberTable, [args(), [depval]]) then
                     RET:= rememberTable[[args(), [depval]]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                   if contains(rememberTableOld, [args(), [depval]]) then
                     RET:= rememberTableOld[[args(), [depval]]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       rememberTable[[args(), [depval]]]:= rememberTableOld[[args(), [depval]]];;
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                   sysassign(` saved values for prog::remember-functions `[[FN,args()]], TRUE);
                   RET:= FKT(args());
                   if nops(rememberTable)>maxRemember then
                     rememberTableOld := rememberTable;
                     rememberTable := table();
                   end_if;
                   if DEP=property::depends and freeIndets([args()])={} then
                     rememberTableConstant[[args()]]:= [[RET], [MAXEFFORT]];
                   else
                     rememberTable[[args(), [depval]]]:= [[RET], [MAXEFFORT]];
                   end_if;
                   RET
                 end_proc,
                 6 = text2expr("remember::".FN),
                 1 = op(FKT, 1))
        end_if
      else // DEP, kein Prevent
        subsop(proc()
                   local RET, depval;
                 option noDebug;
               begin
                 if args(0) > 0 and args(1) = hold(Remember) then
                   //userinfo(10, "Only remember actions ... [".FN."]");
                   if args(2) = hold(ClearPrevent) then
                    //
                   elif args(2) = hold(Clear) then
                      rememberTable:= table();
                      rememberTableOld:= table();
                   elif args(2) = hold(Print) then
                     return(table(rememberTable,rememberTableOld));
                   end_if;
                   return()
                 end_if;
                   if contains(rememberTableConstant, [args()]) then
                     RET:= rememberTableConstant[[args()]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                  depval := DEP(args());
                   if contains(rememberTable, [args(), [depval]]) then
                     RET:= rememberTable[[args(), [depval]]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                   if contains(rememberTableOld, [args(), [depval]]) then
                     RET:= rememberTableOld[[args(), [depval]]];
                     if MAXEFFORT<=op(op(RET,2)) then
                       rememberTable[[args(), [depval]]]:= rememberTableOld[[args(), [depval]]];;
                       userinfo(10, "Result found in remember table... [".FN."]");
                       return(op(op(RET, 1)))
                     end_if
                   end_if;
                 RET:= FKT(args());
                  if nops(rememberTable)>maxRemember then
                    rememberTableOld := rememberTable;
                    rememberTable := table();
                  end_if;
                        if DEP=property::depends and freeIndets([args()])={} then
                          rememberTableConstant[[args()]]:= [[RET], [MAXEFFORT]];
                        else
                          rememberTable[[args(), [depval]]]:= [[RET], [MAXEFFORT]];
                        end_if;
                 RET
               end_proc,
               6 = text2expr("remember::".FN),
               1 = op(FKT, 1))
        end_if
      end_if
    else
      error("wrong type of 1st argument (DOM_PROC or DOM_FUNC_ENV expected)")
    end_if;
    sysassign(prog::rememberFuncs, prog::rememberFuncs union {%});
    %2;
  end_proc:
