prog::setTestConfiguration :=
proc(config : DOM_TABLE)
begin
  if config[hold(TCov)] = TRUE and
     traperror(stdlib::tcov(hold(Debug))) <> 0 then
    context(hold(error)("TCov configuration must be used in a kernel started with -t flag"));
  end_if;
  
  if config[hold(Debug)] = TRUE and debug() <> TRUE then
    context(hold(warning)("Devel configuration should be used in a kernel started with -g flag"));
    debug(TRUE);
  end_if;
    
  testargs(bool(config[hold(Testargs)] = TRUE));
  Pref::typeCheck(config[hold(TypeCheck)]);
  
  if config[hold(WarnAboutErrors)] = TRUE  then
    sysassign(error, proc(str)
                       local nam, errstr;
                     begin
                       nam := "";
                       traperror((nam := expr2text(context(hold(procname)))));
                       errstr := str;
                       if not contains({"", "NIL", "anonymous", NIL,
                                        "DOM_VAR(0,0)"}, nam) then
                         str := str." [".nam."]";
                       end_if;
                       if not contains(map(prog::acceptedErrors,
                                           x -> strmatch(str, stringlib::maskMeta(x)) or strmatch(str, x)),
                                       TRUE) then
                         context(hold(warning)("got error: ".str))
                       end_if;
                       context(hold(prog::syserror)(errstr));
                     end_proc):
  else
    sysassign(error, prog::syserror);
  end_if;
    
  sysassign(prog::TestConfiguration, config);
  null();
end_proc:
