// 

// prog::sort(list, function, Option)
// sorts the given list by the numerical values given by 'function'
//
// Options: Reverse
//

prog::sort:=
  proc(LIST: DOM_LIST, FUNC)
    local INDEX, reverse;
  begin
    if args(0) < 2 then 
       error("At least two arguments expected")
    end_if;
    reverse := bool(_lazy_and(args(0) >= 3, args(3)=hold(Reverse)));
    INDEX := map(LIST, FUNC, args(if reverse then 4 else 3 end_if..args(0)));

    INDEX := map(sort(zip(INDEX, LIST, DOM_LIST), hold(ListsWithKeys)), op, 2);
    
    if reverse then
      revert(INDEX)
    else
      INDEX
    end_if
  end_proc:
