/*++
prog::testinit -- init testing

prog::testinit(f, <expected_ntime>, <Option>)

f                - file name (default is "test")
expected_ntime   - normalized!! Time (with 'prog::ntime') in
                   milli seconds (DOM_INT) or seconds (DOM_FLOAT)
Option           - All   = measure time of whole test
++*/

// global variables
prog::TestErrorCount       := 0:      // number of errors
prog::TestBaseErrorCount   := 0:      // number of baseline errors
prog::TestEnhancementCount := 0:      // number of marked enhancements
prog::TestExpectedTime     := 0:      // expected time factor
prog::TestFullTime         := FALSE:  // measure whole test time : DOM_BOOL
prog::TestNo               := 1:      // number of test call

prog::testinit:=
  proc(f = "test", TIME = 0, TIMEUNIT = 0)
    local inp, opts, nonFailOpts, first, options, types;
  begin
    Pref::report(3):
    inp := Pref::callOnExit();
    
    options := table(All = FALSE, //count difference between 'testinit' and 'testexit'
    // otherwise: only time for evaluating of first
    // arguments inside of 'prog::test' calls is counted
                     // architectures: times
                     "UNIX"   = FAIL, "MSDOS"   = FAIL,
                     "maci"   = FAIL, "maci64"  = FAIL,
                     "glnx86" = FAIL, "glnxa64" = FAIL,
                     "win32"  = FAIL, "win64"   = FAIL,
                     // options for test configuration
                     hold(Devel)           = FAIL,
                     hold(User)            = FAIL,
                     hold(HurtMe)          = FAIL,
                     hold(Version)         = FAIL,
                     hold(Debug)           = FAIL,
                     hold(TCov)            = FAIL,
                     hold(Testargs)        = FAIL,
                     hold(TypeCheck)       = FAIL,
                     hold(WarnAboutErrors) = FAIL
                    );
    
    types := table(hold(Devel)=DOM_BOOL,
                   User=DOM_BOOL,
                   hold(HurtMe)=DOM_BOOL,
                   // lean, lean_pro, ...
                   // currently ignored, but might be in Pref::userOptions
                   hold(Version)= DOM_IDENT,
                   hold(Debug)=DOM_BOOL,
                   hold(TCov)=DOM_BOOL,
                   hold(Testargs)=DOM_BOOL,
                   hold(TypeCheck)=(x -> contains({Always,
                                                  hold(AlwaysWithWarning),
                                                  Interactive,
                                                  None}, x)),
                   hold(WarnAboutErrors)=DOM_BOOL);

    if inp = NIL then inp := [] else inp := [inp] end;
    if contains({op(inp)}, prog::testexit) then
      error("prog::testexit call missing");
    end_if;
    
    first := 1;
    if args(0) > 0 and domtype(f) = DOM_STRING then
      first := 2;
    end_if;
    if args(0) > 1 and domtype(f) = DOM_STRING and
       testtype(TIME, Type::Real) then
      first := 3;
    end_if;
    
    opts:= prog::getOptions(first, [args()], options, TRUE, types)[1];
    // configuration options in Pref::userOptions() have higher precedence
    opts:= table(opts, prog::scanUserOptions());
    
    if contains({opts[hold(Devel)], opts[User], opts[hold(HurtMe)]}, TRUE) then
      // make sure that exactly one of these flags is given
      if nops(select([opts[hold(Devel)], opts[User], opts[hold(HurtMe)]],
                     bool@_equal, TRUE)) <> 1 then
        warning("at most one of the options Devel, User, HurtMe may be given");
      end_if;
    end_if;
    
    nonFailOpts := select(opts, _not@has, FAIL);
    
    if opts[User] = TRUE then
      // set User configuration
      opts := table(opts,
                    hold(Debug)           = FALSE,
                    hold(TCov)            = FALSE,
                    hold(Testargs)        = FALSE,
                    hold(TypeCheck)       = Interactive,
                    hold(WarnAboutErrors) = FALSE,
                    nonFailOpts);
    end_if;
    
    if opts[hold(Devel)] = TRUE then
      // set Devel configuration
      opts := table(opts,
                    hold(Debug)           = TRUE,
                    hold(TCov)            = FALSE,
                    hold(Testargs)        = TRUE,
                    hold(TypeCheck)       = hold(AlwaysWithWarning),
                    hold(WarnAboutErrors) = FALSE,
                    nonFailOpts);
    end_if;
    
    if opts[hold(HurtMe)] = TRUE then
      // set HurtMe configuration
      opts := table(opts,
                    hold(Debug)           = TRUE,
                    hold(TCov)            = FALSE,
                    hold(Testargs)        = TRUE,
                    hold(TypeCheck)       = hold(AlwaysWithWarning),
                    hold(WarnAboutErrors) = TRUE,
                    nonFailOpts);
    end_if;
    
    Pref::callOnExit(inp.[prog::testexit]):
    _pref(hold(Maxmem) = Pref::kernel(BitsInLong)*5*1024);
    
    prog::setTestConfiguration(
       table(prog::TestDefaultConfiguration,
       // do not use nonFailOpts here, opts has changed!
       select(opts, _not@has, FAIL)));
    
    // evaluate time unit -> inside of 'prog::testexit'
    // expected time for whole test
    if testtype(TIME, Type::Real) then
      // expected computing time in normalize time units
      sysassign(prog::TestExpectedTime, TIME)
    elif opts[sysname(Arch)] <> FAIL then
      sysassign(prog::TestExpectedTime, opts[sysname(Arch)])
    elif opts[sysname()] <> FAIL then
      sysassign(prog::TestExpectedTime, opts[sysname()])
    end_if;
    if prog::TestExpectedTime <> 0 then
      sysassign(prog::TestExpectedTime,
                specfunc::trunc(prog::TestExpectedTime*1000))
    end_if;
    
    sysassign(prog::TestNo, 1);
    sysassign(prog::TestFunc, "anonymous");
    sysassign(prog::TestInitTime, time()); // gesamte Zeit
    sysassign(prog::TestTime, 0); // Rechenzeit
    sysassign(prog::TestErrorCount, 0);
    sysassign(prog::TestBaseErrorCount, 0);
    sysassign(prog::TestEnhancementCount, 0);
    sysassign(prog::TestCount, 0);
    sysassign(prog::TestFullTime, opts[All]);
    // for prog::testerrors
    sysassign(prog::TestErrorTable, table());
    sysassign(prog::TestErrorTableNew, table());
    // for prog::testcall
    sysassign(prog::TestErrorCalls, table());
    null()
  end_proc:
