/*  */


property::_insertAssumption := 
proc( cond )
  local list, expandChained, rels;
begin
  
  rels:= {"_leequal", "_less", "_equal", "_unequal"};

  // local method expandChained for transforming a < b < c into a < b and b < c
  expandChained:=
  proc(cond)
  begin
    if contains(rels, type(cond)) then
      if contains(rels, type(op(cond,1))) then
        // we assume that op(cond, 2) is not a relation
        // the contrary may be the case only if the user uses brackets, e.g.,
        // assume((x < y) < (z < u))
        expandChained(op(cond,1)) and subsop(cond,1=op(cond,[1,2]), Unsimplified)
      elif contains(rels, type(op(cond,2))) then
        subsop(cond, 2=op(cond,[2,1]), Unsimplified) and expandChained(op(cond,2))
      else
        cond
      end_if
    elif contains({"_and", "_or", "_not", "_xor", "_implies", "_equiv"}, type(cond)) then
      map(cond, expandChained)
    else
      cond
    end_if 
  end_proc;
  
  cond:= expandChained(cond);
  
  list := property::_getPropertyList ( property::freeIndets(cond) );

  list[ 1 ] := list[ 1 ] union property::freeIndets(cond);
  if type(cond) = "_and"  then 
    cond := op(cond) 
  end_if;
  list[ 2 ] := list[ 2 ] union {cond};
  property::_setAssumptions( list );
  return()
end_proc:
