//   

property::_is := 
proc( ex )
  local res, err, prop, goal, lex;
begin
  if args(0)=1 then
    prop := FAIL;
    goal := UNKNOWN;
  elif args(0)=2 then
    if type(args(2))="_equal" then
      goal := op( args(2), 2 );
      prop := FAIL;
    else
      prop := args(2);
      goal := UNKNOWN;
    end_if;
  elif args(0)=3 then
    prop := args(2);
    goal := op( args(3), 2 );
  end_if;

  lex:= length(ex);
  if lex > property::MAXLENGTH  and freeIndets(ex) <> {} then
    userinfo(2, "Break: input expression is too complex (".expr2text(length(ex)).")! [property::is]");
    return(not goal)
  end_if;

  if type( (ex := property::_rewrite_cond( ex, prop, goal ) ) )=DOM_BOOL then
    err := 0;
    res := ex;
  else
    err := traperror( (res := simplify::simplifyCondition( ex, UseSolver=FALSE )) );
  end_if;

  case err
    /* MAXDEPTH */
    of 1010 do
      lasterror();
    of 0 do
      break;
    otherwise
      res := UNKNOWN;
  end_case;
  if type(res)<>DOM_BOOL then res := UNKNOWN; end_if;
  if res=UNKNOWN and goal<>UNKNOWN then res := not goal; end_if;
  return( res );
end_proc: /* property::_is */

property::_is:=
  prog::remember(property::_is, property::depends, hold(PreventRecursion), UNKNOWN):
