//
alias(MAXEFFORT_BOUND=1000.0);

property::_rectform := proc( xpr, options=table() )
  local i, v, res;
  save MAXEFFORT;
begin
  if MAXEFFORT<MAXEFFORT_BOUND then return(FAIL); end_if;
  if property::_typereal( xpr, options )=TRUE then return( [xpr,0] ); end_if;
  case type(xpr)
    of DOM_IDENT do
      if property::_typereal( xpr, options )=TRUE then
        return( [xpr,0] );
      end_if;
      break;
    of "exp" do
      if ( v := property::_rectform( op(xpr), options ) ) = FAIL then break; end_if;
      return( [ exp(v[1])*cos(v[2]), exp(v[1])*sin(v[2]) ] );
    of "_plus" do
      res := [0,0];
      MAXEFFORT:=MAXEFFORT/nops(xpr);
      if MAXEFFORT<MAXEFFORT_BOUND then break; end_if;
      for i in [op(xpr)] do
        v := property::_rectform( i, options ):
        if v=FAIL then break; end_if;
        if type(v[1])="Re" and has(res[1], hold(Re))
          or type(v[2])="Im" and has(res[2], hold(Im)) then
          break;
        end_if;
        res := zip( res, v, _plus );
      end_for;
      if v=FAIL then break; end_if;
      return( res );
    of "_mult" do
      res := [1,0];
      MAXEFFORT:=MAXEFFORT/nops(xpr);
      if MAXEFFORT<MAXEFFORT_BOUND then break; end_if;
      for i in [op(xpr)] do
        v := property::_rectform( i, options ):
        if v=FAIL then break; end_if;
        if type(v[1])="Re" and has(res[1], hold(Re))
          or type(v[2])="Im" and has(res[2], hold(Im)) then
          break;
        end_if;
        res := [ res[1]*v[1] - res[2]*v[2], res[1]*v[2] + res[2]*v[1] ];
      end_for;
      if v=FAIL then break; end_if;
      return( res );
    of DOM_COMPLEX do
      return( [op(xpr)] );
    of DOM_RAT do
    of DOM_INT do
    of DOM_FLOAT do
      return( [xpr,0] );
  end_case;
  if options["symbolic"]=TRUE then
    return( [ hold(Re)(xpr), hold(Im)(xpr) ] );
  end_if;
  return( FAIL );
end_proc; /* property::_rectform */
