//   

alias(hasBit(X, k) = bool((X mod 2^(k + 1)) div 2^k <> 0)):

/* 
property::_rewrite_cond_inequality(ex, goal, level)

returns ex, or TRUE/FALSE/UNKNOWN if it can decide ex 

Only for inequalities of the form a*x + b < 0 can we reach a decision here
 
*/
property::_rewrite_cond_inequality := 
proc(ex, goal=UNKNOWN, level=0)
  local inds, lhs, p, props, sig, sigC;
begin
  lhs:= op(ex, 1) - op(ex, 2);
  
  /* bei infinity aussteigen, damit is(infinity<=X) in simplifyCondition bearbeitet wird */
  if has(ex,{infinity,RD_INF,RD_NINF}) 
  or nops( (inds := freeIndets(ex)) ) <> 1 
  or indets(lhs, PolyExpr) <> inds 
  then
    return(ex)
  end_if;  
  
  
  inds := op(inds);
  if ((props:= properties(inds))) = FAIL then
    if goal=TRUE or level=0 then 
      return(UNKNOWN) 
    else 
      return(ex)
    end_if
  else
    props:= op(props, 1)
  end_if;
  
  p:= Type::Linear(lhs, [inds]);  
  if p = FALSE then 
    return(ex)
  end_if;
   
    
  if property::_typereal(p)<>TRUE then 
    return(ex)
  end_if; /* we won't analyze polynoms without real constants*/
    
  
  sig := sign(p[1]);
  sigC := sign(p[2]);
  /* Test for sys-properties */
  if hasBit(props,3) then /* We know: 0 < ind */
    if sig=1 then
     /* Condition: ind + C </<= 0
      * If C is 0 or positive this is FALSE otherwise we can't decide */
      if sigC>=0 then 
        return(FALSE)
      else 
        return(ex) 
      end_if;
    end_if;
    if sig=-1 then
          /* Condition: 0 < or <= ind - C
             when C is 0 or negative this is TRUE otherwise we can't decide */
      if sigC<=0 then return(TRUE); else return(ex); end_if;
    end_if;
  end_if;

  if hasBit(props,4) then /* We know: ind < 0 */
    if sig=1 then
          /* Condition: ind + C </<= 0
           * If C is 0 or negative this is TRUE otherwise we can't decide */
      if sigC<=0 then return(TRUE); else return(ex); end_if;
    end_if;
    if sig=-1 then
          /* Condition: 0 </<= ind - C
           * If C is 0 or positive this is FALSE otherwise we can't decide */
      if sigC>=0 then return(FALSE); else return(ex); end_if;
    end_if;
  end_if;

  if hasBit(props,2) then /* We know: 0 <= ind */
    if sig=1 then
          /* Condition: ind + C </<= 0
           * If C is positive or C is 0 and the equation is "_less" this is FALSE
           * if C is 0 and the equation is "_leequal" then ind has to be 0
           * otherwise we can't decide */
     if sigC>0 then
       return(FALSE);
     elif sigC=0 then
       if type(ex)="_less" then
         return(FALSE);
       else
         return( inds=0 );
       end_if;
     else
       return(ex);
     end_if;
   end_if;
   if sig=-1 then
          /* Condition: 0 </<= ind - C
           * If C is negative or C is 0 and the equation is "_leequal" this is TRUE
           * if C is 0 and the equation is "_less" then ind must not be 0
            * otherwise we can't decide */
     if sigC<0 then
       return(TRUE);
     elif sigC=0 then
       if type(ex)="_leequal" then
         return(TRUE);
       else
         return( inds<>0 );
       end_if;
     else
       return(ex);
     end_if;
   end_if;
 end_if;
 ex
end_proc: /* property::_rewrite_cond_inequality */
