/*  */

/* set2sysprop.mu
 * Aus Obermengen Systemproperties erzeugen
 */

    /* System-properties auswerten und eintragen */
    /* 1 Complex
     * 2 Reell
     * 3 >=0
     * 4 >0
     * 5 <0
     * 6 Z_
     * 7 =0
     * 8 <>0
     * 9=1
     */

property::_set2sysprop := proc( set )
local sysprops, j, v;
begin
  sysprops := [ 1, 0 $ 8 ];

  /* Zuerst berladung */
  if set::dom::_set2sysprop<>FAIL then
    sysprops := zip( sysprops, set::dom::_set2sysprop( set ), max );
    next
  end_if:

  case type(set)
    of "_intersect" do
      for j in [op(set)] do
        sysprops := zip( sysprops, property::_set2sysprop( j ), max );
      end_for;
      break;
    of "_minus" do
      // set the system properties of the first operand
      // TODO: we may want to set <>0 if the second operand contains zero
      sysprops := zip(sysprops, property::_set2sysprop(op(set,1)), max);
      break;
    of DOM_SET do
      v := [1, 1, 1, 1, 1, 1, 0, 1, 0];
      for j in set do
        // if j <> 0 then v := v minus {7};end_if;  /* =0 */
        // if j <> 1 then v := v minus {9}; end_if; /* =1 */
        case type(j)
          of DOM_IDENT do
            if not contains( {PI}, j ) then
              v := sysprops;
              break;
            end_if;
          of DOM_FLOAT do
          of DOM_RAT do
            v[6] := 0; /* ganzzahl */
          of DOM_INT do
            if iszero(j) then v[4] := v[5] := v[8] := 0; end_if; /* >0, <0, <>0 */
            if j < 0 then v[3] := v[4] := 0; end_if; /* >=0, > 0 */
            if j > 0 then v[5] := 0; end_if; /* < 0 */
            break;
          otherwise
            v := sysprops;
            break;
        end_case;
        if v=sysprops then
          return(sysprops);
        end_if;
      end_for:
      return(v);
    of solvelib::BasicSet do
      case set
        of Z_ do
          sysprops[ 2 ] := 1; /* reell */
          sysprops[ 6 ] := 1; /* ganzzahl */
          break;
        of Q_ do
        of R_ do
          sysprops[ 2 ] := 1; /* reell */
          break;
      end_case;
      break;
    of Dom::Interval do
      sysprops[ 2 ] := 1; /* reell */
      if property::_decide(Dom::Interval::right( set )<=0, table("Constant"=TRUE))=TRUE then
        if Dom::Interval::isrightopen( set ) or property::_decide(Dom::Interval::right( set )<0, table("Constant"=TRUE))=TRUE then
          sysprops[ 5 ] := 1; /* <0 */
          sysprops[ 8 ] := 1; /* <>0 */
        end_if;
      elif property::_decide(Dom::Interval::left( set )>=0, table("Constant"=TRUE))=TRUE then
        sysprops[ 3 ] := 1; /* >=0 */
        if Dom::Interval::isleftopen( set ) or property::_decide(Dom::Interval::left( set )>0, table("Constant"=TRUE))=TRUE then
          sysprops[ 4 ] := 1; /* >0 */
          sysprops[ 8 ] := 1; /* <>0 */
        end_if;
      end_if;
      break;
  end_case;

  /* Kernproperties =0 und =1 entfernen */
  sysprops[7] := 0;
  sysprops[9] := 0;
  sysprops;
end_proc:
