//   

alias(hasBit(X, k) = bool((X mod 2^(k + 1)) div 2^k <> 0)):

property::_typeinteger := proc( xpr, options=table() )
  local inds, res, haveFalse, i;
begin
  inds := indets( xpr ) minus Type::ConstantIdents;
  if inds={} then
    return(property::isConstInteger(xpr));
  end_if;

  if type(xpr)<>DOM_IDENT and map(inds, property::_typeinteger)={TRUE} then
    res := property::checkPolyInteger(xpr);
    if res<>UNKNOWN then return(res); end_if;
  end_if;

  case type(xpr)
    of DOM_IDENT do
      // check system properties
      if ( i:=properties(xpr) )<>FAIL and hasBit(op(i,1),5) then return(TRUE); end_if;
      break;
    of DOM_INT do return( TRUE );
    of DOM_RAT do return( FALSE );
    of "_power" do
      // check if base and exponent are of type integer
      if property::_typeinteger(op(xpr,1), options)=TRUE and property::_typeinteger(op(xpr,2), options)=TRUE then
        case property::_decide(op(xpr,2)>=0, options)
          of TRUE do
            // if exponent is positive xpr is of type integer
            return(TRUE);
          of FALSE do
            // if exponent is not positive and the base is no unit, then xpr is _not_ of type integer
            if property::_decide(op(xpr,1)<>1, options)=TRUE and property::_decide(op(xpr,1)<>-1, options)=TRUE then
              return(FALSE);
            end_if;
        end_case;
      end_if;
      break;
    of "_plus" do
      /* check cases:
        * 1) all summands integer => sum is integer
        * 2) any summand cant be decided => UNKNOWN
        * 3) only one summand is not integer => sum is not integer
        */
      haveFalse := FALSE;
      for i in [op(xpr)] do
        if type(i)=DOM_INT then next; end;
        case property::_typeinteger(i, options)
          of TRUE do break;
          of UNKNOWN do return( UNKNOWN );
          of FALSE do
            if options["seek"]=TRUE then return( UNKNOWN ); end_if;
            if haveFalse then return( UNKNOWN ); end_if;
            haveFalse := TRUE;
        end_case;
      end_for;
      return( not haveFalse );
    of "_mult" do
      /* check cases:
        * 1) all factors integer => product is integer
        * 2) any factors cant be decided or is not integer => UNKNOWN
        */
      haveFalse := FALSE;
      for i in [op(xpr)] do
        if type(i)=DOM_INT then next; end;
        case property::_typeinteger(i, options)
          of TRUE do
            break;
          of UNKNOWN do
          of FALSE do
            haveFalse := TRUE;
            break;
        end_case;
        if haveFalse then break; end_if;
      end_for;
      if not haveFalse then
        return(TRUE);
      end_if;
  end_case;
  return(property::_typereal( xpr, options ) and UNKNOWN);
end_proc: /* property::_typeinteger */
