/*  */

/* property::_typeodd()
 * checks whether xpr is an odd integer
 */
property::_typeodd := proc( xpr, options=table() )
  local prop, A, i, odd;
begin
  case type(xpr)
    of "_mult" do
      odd := TRUE;
      for i in [op(xpr)] do
        if property::_typeinteger(i, options)<>TRUE then return( UNKNOWN ); end_if;
        if odd=TRUE then odd := UNKNOWN or property::_typeodd( i ); end_if;
      end_for;
      return( odd );
    of DOM_RAT do
      return( FALSE );
    of DOM_INT do
      return( bool(xpr mod 2 = 1) );
    of DOM_IDENT do
      if contains({CATALAN, EULER, PI}, xpr) then
        return(FALSE);
      end_if;
      prop := property::_getprop( xpr );
      if type(prop)=DOM_SET then
        /* avoid endless recursion */
        if contains(prop, xpr) then
          return(UNKNOWN);
        end_if;
        return( _and( op(map(prop, property::_typeodd, options)) ) );
      end_if;
      if type(prop)<>Dom::ImageSet then return( UNKNOWN ); end_if;
      if  (A := Dom::ImageSet::isisetLinear(prop) )<>FALSE and _subset(Dom::ImageSet::sets(prop)[1], Z_) = TRUE and type(A[1])=DOM_INT and type(A[2])=DOM_INT and A[1] mod 2 = 0 then
        return( bool(A[2] mod 2 = 1) );
      end_if;
      return( UNKNOWN );
  end_case:
  return( UNKNOWN );
end_proc:
