//   

/*
    property::complexity(EXPR)

    returns an integer value representing the complexity of a
    given expression
    cf. Simplify::defaultValuation

    copied here from the former lib/PROP/Propisr.mu
*/



// returns an integer value correlated to the complexity of a
// given expression
property::complexity:=
proc(EXPR)
  local compl, DEPTH, LENGTH, OPR, T, k;
  option remember;
  begin
    compl:=
      proc(EXPR)
        local c;
        option remember;
      begin
        if domtype(EXPR) = DOM_EXPR then
          c:= map([op(EXPR)], compl);
          T:= table(type(EXPR) = 1);
          if nops(c) = 0 then
            0, 0, DEPTH, []
          else
            // number off all operands
            _plus(op(c, 4*k-3) $ k = 1..nops(c)/4),
            // max number operands of one subexpression
            stdlib::max(nops(EXPR), op(c, 4*k-2) $ k = 1..nops(c)/4),
            // maximal expr tree depth
            DEPTH*(1 + max(op(c, 4*k-1) $ k = 1..nops(c)/4)),
            // table of all operators and types
            (map(map([op(c, 4*k) $ k = 1..nops(c)/4], op),
                 X -> (if contains(T, op(X, 1)) then
                         T[op(X, 1)] := T[op(X, 1)] + op(X, 2)
                       else
                         T[op(X, 1)]:= op(X, 2)
                       end_if)); T)
          end_if
        else
          nops(EXPR)*LENGTH, nops(EXPR)*LENGTH, 0, table(type(EXPR) = 1)
        end_if
      end_proc;

    DEPTH:= 1;
    LENGTH:= 1;
    OPR:= table("All" = 1);


    [compl, LENGTH, DEPTH, OPR]:= [compl(EXPR)];

    //print("sum nops" = compl, "max nops" = LENGTH, "max depth" = DEPTH, OPR);

    // standard arithmetic
    OPR:= split(OPR, X -> contains([DOM_IDENT,DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX,
                                    "_plus", solvelib::BasicSet, "_equal", "_unequal"], op(X, 1)) > 0);
    T:= split(op(OPR, 2), X -> contains(["_mult", "_power", "_and", "_or", "_in",
                                         DOM_SET,"_leequal", "_less"], op(X, 1)) > 0);

    max(compl, LENGTH)
    + DEPTH*_plus(op(map([op(op(OPR, 1))], op, 2)))
    + 2*DEPTH*_plus(op(map([op(op(T, 1))], op, 2)))
    + 4*DEPTH*_plus(op(map([op(op(T, 2))], op, 2)))
  end_proc:

