// converts a property expression
property::prop2set:=
proc(EX)
begin
  case type(EX)
    of "_or" do
      EX:= map([op(EX)], property::prop2set);
      _union(op(EX));
      break
    of "_and" do
      EX:= map([op(EX)], property::prop2set);
      _intersect(op(EX));
      break
    of "_not" do
      EX:= property::prop2set(op(EX));
      C_ minus EX;
      break
    of "Interval" do
      Dom::Interval::convert(EX);
      break
    of "Residue" do
      Dom::ImageSet(#k*op(extop(EX, 3), 2)+op(extop(EX, 3), 1), #k, Z_) intersect property::prop2set(op(extop(EX, 3), 3));
      break
    otherwise
      if testtype(EX, Type::Property) then
        case EX
          of Type::Complex do
            return(C_);
          of Type::Imaginary do
            return(I*R_);
          of Type::Integer do
            return(Z_);
          of Type::IntImaginary do
            return(I*Z_);
          of Type::Irrational do
            return(R_ minus Q_);
          of Type::Negative do
            return(Dom::Interval(-infinity, 0));
          of Type::NegInt  do
            return(Dom::Interval(-infinity, 0) intersect Z_);
          of Type::NegRat do
            return(Dom::Interval(-infinity, 0) intersect Q_);
          of Type::NonNegInt  do
            return(Dom::Interval([0], infinity) intersect Z_);
          of Type::NonNegRat do
            return(Dom::Interval([0], infinity) intersect Q_);
          of Type::NonNegative do
            return(Dom::Interval([0], infinity));
          of Type::NonZero do
            return(C_ minus {0});
          of Type::Positive do
            return(Dom::Interval(0, infinity));
          of Type::PosInt do
            return(Dom::Interval(0, infinity) intersect Z_);
          of Type::PosRat do
            return(Dom::Interval(0, infinity) intersect Q_);
          of Type::Rational do
            return(Q_);
          of Type::Real do
            return(R_);
          of Type::Zero do
            return({0});
          otherwise
            C_;
        end_case;
      else
        EX;
      end_if
  end_case:
end_proc:
