/* property::simplifyZPolyResidueProp
 * Input:
 *  xpr: Ausdruck
 * Output:
 *  Der Ausdruck, in dem alle Bezeichner X, die die Eigenschaft haben,
 *  aus Restklassen ber Z_ (X=a*Z_+b) zu bestehen, ersetzt werden durch a*X+b
 */
property::simplifyZPolyResidueProp := proc(xpr)
  local inds, i, prop, A;
begin
  inds := freeIndets(xpr);
  for i in inds do
    prop := getprop(i, "Constant"=TRUE, "Targets"={Dom::ImageSet, DOM_SET});

    if type(prop)=Dom::ImageSet then
      if  (A := Dom::ImageSet::isisetLinear(prop) )<>FALSE and _subset(Dom::ImageSet::sets(prop)[1], Z_) = TRUE and (type(A[1])=DOM_INT or type(A[1])=DOM_RAT) and (type(A[2])=DOM_INT or type(A[2])=DOM_RAT) then
        xpr := subs(xpr, i=A[1]*i+A[2]);
      end_if;
    end_if;
  end_for;
  xpr;
end_proc:

