/* property::splitRoots
 * Input:
 *  xpr: A mathematical expression containing roots
 * Output:
 *  FAIL if xpr could not be fragmented
 *  A list [factor, rfactor, exp, remain] such that
 *  xpr = factor*rfactor + remain
 *  and factor, rfactor^exp and remain contain no roots
 */
property::splitRoots := proc(xpr)
  local s, remain, exponent;
begin
  /* Let xpr be the list of summands */
  if type(xpr)="_plus" then
    xpr := [op(xpr)];
  else
    xpr := [xpr];
  end_if;

  /* Split xpr, let all summands containing roots be in the first list */
  s:=split(xpr, proc(X)
    local i;
    begin
      if type(X)="_mult" then
        X := [op(X)];
      else
        X:=[X];
      end_if;
      for i in X do
        if type(i)="_power" and type(op(i,2))=DOM_RAT then return(TRUE); end_if;
      end_for;
      FALSE;
    end_proc);

  /* For now we handle only one root summand */
  if nops(s[1])<>1 then return(FAIL); end_if;

  remain := _plus(op(s[2]));
  /* Let s be the list of all factors */
  if type(op(s[1]))="_mult" then
    s := [op(op(s[1]))];
  else
    s := [op(s[1])];
  end_if;

  /* Split s, let all roots be in the first list */
  s := split(s, proc(X)
    begin
      return(bool(type(X)="_power" and type(op(X,2))=DOM_RAT));
    end_proc);

  /* Calculate the smallest exponent needed to remove roots */
  exponent := ilcm(op(map(s[1], X->denom(op(X,2)))));

  return([_mult(op(s[2])), _mult(op(s[1])), exponent, remain]);
end_proc:
